@extends('adminlte::page')

@section('title', 'Case Statistics')

@section('content_header')
    <h1>Case Statistics Dashboard</h1>
@stop

@section('content')
<div class="row">
    <div class="col-lg-3 col-6">
        <div class="small-box bg-info">
            <div class="inner">
                <h3>{{ $totalCases }}</h3>
                <p>Total Cases</p>
            </div>
            <div class="icon">
                <i class="fas fa-folder"></i>
            </div>
            <a href="{{ route('cases.index') }}" class="small-box-footer">
                View All Cases <i class="fas fa-arrow-circle-right"></i>
            </a>
        </div>
    </div>
    
    <div class="col-lg-3 col-6">
        <div class="small-box bg-success">
            <div class="inner">
                <h3>{{ $openCases }}</h3>
                <p>Open Cases</p>
            </div>
            <div class="icon">
                <i class="fas fa-folder-open"></i>
            </div>
            <a href="{{ route('cases.index', ['status' => 'open,under_investigation,pending_review']) }}" class="small-box-footer">
                View Open Cases <i class="fas fa-arrow-circle-right"></i>
            </a>
        </div>
    </div>
    
    <div class="col-lg-3 col-6">
        <div class="small-box bg-warning">
            <div class="inner">
                <h3>{{ $closedCases }}</h3>
                <p>Closed Cases</p>
            </div>
            <div class="icon">
                <i class="fas fa-folder-minus"></i>
            </div>
            <a href="{{ route('cases.index', ['status' => 'closed']) }}" class="small-box-footer">
                View Closed Cases <i class="fas fa-arrow-circle-right"></i>
            </a>
        </div>
    </div>
    
    <div class="col-lg-3 col-6">
        <div class="small-box bg-danger">
            <div class="inner">
                <h3>{{ $criticalPriorityCases }}</h3>
                <p>Critical Priority Cases</p>
            </div>
            <div class="icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <a href="{{ route('cases.index', ['priority' => 'critical']) }}" class="small-box-footer">
                View Critical Cases <i class="fas fa-arrow-circle-right"></i>
            </a>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-chart-pie mr-1"></i>
                    Cases by Status
                </h3>
            </div>
            <div class="card-body">
                <canvas id="casesByStatusChart" height="300"></canvas>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-chart-pie mr-1"></i>
                    Cases by Priority
                </h3>
            </div>
            <div class="card-body">
                <canvas id="casesByPriorityChart" height="300"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-chart-line mr-1"></i>
                    Cases Trend (Last 12 Months)
                </h3>
            </div>
            <div class="card-body">
                <canvas id="casesTrendChart" height="300"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-table mr-1"></i>
                    Case Status Breakdown
                </h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Status</th>
                            <th>Count</th>
                            <th>Percentage</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $statusLabels = [
                                'open' => 'Open',
                                'under_investigation' => 'Under Investigation',
                                'pending_review' => 'Pending Review',
                                'closed' => 'Closed',
                                'reopened' => 'Reopened',
                                'archived' => 'Archived',
                            ];
                        @endphp
                        
                        @foreach($casesByStatus as $status => $count)
                            <tr>
                                <td>{{ $statusLabels[$status] ?? ucfirst($status) }}</td>
                                <td>{{ $count }}</td>
                                <td>{{ number_format(($count / $totalCases) * 100, 1) }}%</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.7.1/dist/chart.min.js"></script>
    <script>
        $(document).ready(function() {
            // Case Status Chart
            const statusLabels = {
                'open': 'Open',
                'under_investigation': 'Under Investigation',
                'pending_review': 'Pending Review',
                'closed': 'Closed',
                'reopened': 'Reopened',
                'archived': 'Archived'
            };
            
            const statusColors = {
                'open': '#28a745',
                'under_investigation': '#007bff',
                'pending_review': '#ffc107',
                'closed': '#6c757d',
                'reopened': '#17a2b8',
                'archived': '#343a40'
            };
            
            const statusData = @json($casesByStatus);
            const statusLabelsArray = [];
            const statusDataArray = [];
            const statusColorsArray = [];
            
            for (const [key, value] of Object.entries(statusData)) {
                statusLabelsArray.push(statusLabels[key] || key);
                statusDataArray.push(value);
                statusColorsArray.push(statusColors[key] || '#6c757d');
            }
            
            const statusCtx = document.getElementById('casesByStatusChart').getContext('2d');
            new Chart(statusCtx, {
                type: 'doughnut',
                data: {
                    labels: statusLabelsArray,
                    datasets: [{
                        data: statusDataArray,
                        backgroundColor: statusColorsArray,
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'right',
                        }
                    }
                }
            });
            
            // Case Priority Chart
            const priorityLabels = {
                'low': 'Low',
                'medium': 'Medium',
                'high': 'High',
                'critical': 'Critical'
            };
            
            const priorityColors = {
                'low': '#17a2b8',
                'medium': '#007bff',
                'high': '#ffc107',
                'critical': '#dc3545'
            };
            
            const priorityData = @json($casesByPriority);
            const priorityLabelsArray = [];
            const priorityDataArray = [];
            const priorityColorsArray = [];
            
            for (const [key, value] of Object.entries(priorityData)) {
                priorityLabelsArray.push(priorityLabels[key] || key);
                priorityDataArray.push(value);
                priorityColorsArray.push(priorityColors[key] || '#6c757d');
            }
            
            const priorityCtx = document.getElementById('casesByPriorityChart').getContext('2d');
            new Chart(priorityCtx, {
                type: 'doughnut',
                data: {
                    labels: priorityLabelsArray,
                    datasets: [{
                        data: priorityDataArray,
                        backgroundColor: priorityColorsArray,
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'right',
                        }
                    }
                }
            });
            
            // Cases Trend Chart
            const trendLabels = @json($monthLabels);
            const trendData = @json($monthData);
            
            const trendCtx = document.getElementById('casesTrendChart').getContext('2d');
            new Chart(trendCtx, {
                type: 'line',
                data: {
                    labels: trendLabels,
                    datasets: [{
                        label: 'New Cases',
                        data: trendData,
                        backgroundColor: 'rgba(0, 123, 255, 0.2)',
                        borderColor: 'rgba(0, 123, 255, 1)',
                        borderWidth: 2,
                        tension: 0.3,
                        fill: true
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                precision: 0
                            }
                        }
                    }
                }
            });
        });
    </script>
@stop
