@extends('adminlte::page')

@section('title', 'Edit Suspect')

@section('content_header')
    <h1>Edit Suspect: {{ $suspect->full_name }}</h1>
@stop

@section('content')
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <form action="{{ route('case-suspects.update', $suspect->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="case_id">Case <span class="text-danger">*</span></label>
                            <select class="form-control @error('case_id') is-invalid @enderror" id="case_id" name="case_id" required>
                                <option value="">-- Select Case --</option>
                                @foreach($cases as $caseItem)
                                    <option value="{{ $caseItem->id }}" {{ (old('case_id', $suspect->case_id) == $caseItem->id) ? 'selected' : '' }}>
                                        #{{ $caseItem->case_number }} - {{ $caseItem->title }}
                                    </option>
                                @endforeach
                            </select>
                            @error('case_id')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <h4 class="mt-4">Personal Information</h4>
                <hr>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="full_name">Full Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('full_name') is-invalid @enderror" id="full_name" name="full_name" value="{{ old('full_name', $suspect->full_name) }}" required>
                            @error('full_name')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="date_of_birth">Date of Birth</label>
                            <input type="date" class="form-control @error('date_of_birth') is-invalid @enderror" id="date_of_birth" name="date_of_birth" value="{{ old('date_of_birth', $suspect->date_of_birth ? $suspect->date_of_birth->format('Y-m-d') : '') }}">
                            @error('date_of_birth')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="gender">Gender</label>
                            <select class="form-control @error('gender') is-invalid @enderror" id="gender" name="gender">
                                <option value="">-- Select Gender --</option>
                                <option value="male" {{ old('gender', $suspect->gender) == 'male' ? 'selected' : '' }}>Male</option>
                                <option value="female" {{ old('gender', $suspect->gender) == 'female' ? 'selected' : '' }}>Female</option>
                                <option value="other" {{ old('gender', $suspect->gender) == 'other' ? 'selected' : '' }}>Other</option>
                            </select>
                            @error('gender')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="address">Address</label>
                            <textarea class="form-control @error('address') is-invalid @enderror" id="address" name="address" rows="3">{{ old('address', $suspect->address) }}</textarea>
                            @error('address')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="phone">Contact Number</label>
                            <input type="text" class="form-control @error('phone') is-invalid @enderror" id="phone" name="phone" value="{{ old('phone', $suspect->phone) }}">
                            @error('phone')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="id_type">ID Type</label>
                            <select class="form-control @error('id_type') is-invalid @enderror" id="id_type" name="id_type">
                                <option value="">-- Select ID Type --</option>
                                @foreach($idTypes as $key => $value)
                                    <option value="{{ $key }}" {{ old('id_type', $suspect->id_type) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                @endforeach
                            </select>
                            @error('id_type')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="id_number">ID Number</label>
                            <input type="text" class="form-control @error('id_number') is-invalid @enderror" id="id_number" name="id_number" value="{{ old('id_number', $suspect->id_number) }}">
                            @error('id_number')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="alias">Alias/Nickname</label>
                            <input type="text" class="form-control @error('alias') is-invalid @enderror" id="alias" name="alias" value="{{ old('alias', $suspect->alias) }}">
                            @error('alias')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="photo">Suspect Photo</label>
                            @if($suspect->photo_path)
                                <div class="mb-2">
                                    <img src="{{ asset('storage/' . $suspect->photo_path) }}" alt="Suspect Photo" class="img-thumbnail" style="max-height: 150px;">
                                    <p class="text-muted">Current photo</p>
                                </div>
                            @endif
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('photo') is-invalid @enderror" id="photo" name="photo">
                                    <label class="custom-file-label" for="photo">Choose new file</label>
                                </div>
                            </div>
                            <small class="form-text text-muted">Leave empty to keep current photo. Accepted formats: JPG, PNG. Max size: 5MB</small>
                            @error('photo')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <h4 class="mt-4">Arrest Information</h4>
                <hr>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_arrested" name="is_arrested" {{ old('is_arrested', $suspect->is_arrested) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_arrested">Arrested</label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_charged" name="is_charged" {{ old('is_charged', $suspect->is_charged) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_charged">Charged</label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_in_custody" name="is_in_custody" {{ old('is_in_custody', $suspect->is_in_custody) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_in_custody">In Custody</label>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row arrest-details" style="display: none;">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="arrest_date">Arrest Date</label>
                            <input type="datetime-local" class="form-control @error('arrest_date') is-invalid @enderror" id="arrest_date" name="arrest_date" value="{{ old('arrest_date', $suspect->arrest_date ? $suspect->arrest_date->format('Y-m-d\TH:i') : '') }}">
                            @error('arrest_date')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="arrested_by_officer_id">Arresting Officer</label>
                            <select class="form-control @error('arrested_by_officer_id') is-invalid @enderror" id="arrested_by_officer_id" name="arrested_by_officer_id">
                                <option value="">-- Select Officer --</option>
                                @foreach($officers as $officer)
                                    <option value="{{ $officer->id }}" {{ old('arrested_by_officer_id', $suspect->arrested_by_officer_id) == $officer->id ? 'selected' : '' }}>
                                        {{ $officer->rank }} {{ $officer->name }} ({{ $officer->badge_number ?? 'No Badge' }})
                                    </option>
                                @endforeach
                            </select>
                            @error('arrested_by_officer_id')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="arrest_location">Arrest Location</label>
                            <input type="text" class="form-control @error('arrest_location') is-invalid @enderror" id="arrest_location" name="arrest_location" value="{{ old('arrest_location', $suspect->arrest_location) }}">
                            @error('arrest_location')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row charge-details" style="display: none;">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="charges">Charges</label>
                            <textarea class="form-control @error('charges') is-invalid @enderror" id="charges" name="charges" rows="3">{{ old('charges', $suspect->charges) }}</textarea>
                            @error('charges')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row custody-details" style="display: none;">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="custody_location">Custody Location</label>
                            <input type="text" class="form-control @error('custody_location') is-invalid @enderror" id="custody_location" name="custody_location" value="{{ old('custody_location', $suspect->custody_location) }}">
                            @error('custody_location')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="cell_number">Cell Number</label>
                            <input type="text" class="form-control @error('cell_number') is-invalid @enderror" id="cell_number" name="cell_number" value="{{ old('cell_number', $suspect->cell_number) }}">
                            @error('cell_number')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="officer_notes">Notes</label>
                            <textarea class="form-control @error('officer_notes') is-invalid @enderror" id="officer_notes" name="officer_notes" rows="3">{{ old('officer_notes', $suspect->officer_notes) }}</textarea>
                            @error('officer_notes')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-12">
                        <a href="{{ url()->previous() }}" class="btn btn-secondary">Cancel</a>
                        <button type="submit" class="btn btn-primary float-right">Update Suspect</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Arrest Information Update -->
    <div class="card mt-4">
        <div class="card-header">
            <h3 class="card-title">Update Arrest Information</h3>
        </div>
        <div class="card-body">
            <form action="{{ route('case-suspects.update-arrest', $suspect->id) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="update_is_arrested" name="is_arrested" {{ $suspect->is_arrested ? 'checked' : '' }}>
                                <label class="custom-control-label" for="update_is_arrested">Arrested</label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="arrest_date">Arrest Date</label>
                            <input type="date" class="form-control" id="arrest_date" name="arrest_date" value="{{ $suspect->arrest_date ? $suspect->arrest_date->format('Y-m-d') : '' }}">
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="arrested_by_officer_id">Arresting Officer</label>
                            <select class="form-control" id="arrested_by_officer_id" name="arrested_by_officer_id">
                                <option value="">-- Select Officer --</option>
                                @foreach($officers as $officer)
                                    <option value="{{ $officer->id }}" {{ $suspect->arrested_by_officer_id == $officer->id ? 'selected' : '' }}>{{ $officer->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="arrest_location">Arrest Location</label>
                            <input type="text" class="form-control" id="arrest_location" name="arrest_location" value="{{ $suspect->arrest_location }}">
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="arrest_notes">Arrest Notes</label>
                            <textarea class="form-control" id="arrest_notes" name="arrest_notes" rows="3"></textarea>
                            <small class="form-text text-muted">Provide details about this arrest update</small>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-12">
                        <button type="submit" class="btn btn-warning float-right">Update Arrest Status</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Charge Information Update -->
    <div class="card mt-4">
        <div class="card-header">
            <h3 class="card-title">Update Charge Information</h3>
        </div>
        <div class="card-body">
            <form action="{{ route('case-suspects.update-charge', $suspect->id) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="update_is_charged" name="is_charged" {{ $suspect->is_charged ? 'checked' : '' }}>
                                <label class="custom-control-label" for="update_is_charged">Charged</label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="charge_date">Charge Date</label>
                            <input type="date" class="form-control" id="charge_date" name="charge_date" value="{{ $suspect->charge_date ? $suspect->charge_date->format('Y-m-d') : '' }}">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="charges">Charge Details</label>
                            <textarea class="form-control" id="charges" name="charges" rows="2">{{ $suspect->charges }}</textarea>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="charge_notes">Charge Notes</label>
                            <textarea class="form-control" id="charge_notes" name="charge_notes" rows="3"></textarea>
                            <small class="form-text text-muted">Provide details about this charge update</small>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-12">
                        <button type="submit" class="btn btn-warning float-right">Update Charge Status</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Custody Information Update -->
    <div class="card mt-4">
        <div class="card-header">
            <h3 class="card-title">Update Custody Information</h3>
        </div>
        <div class="card-body">
            <form action="{{ route('case-suspects.update-custody', $suspect->id) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_in_custody" name="is_in_custody" {{ $suspect->is_in_custody ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_in_custody">In Custody</label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="custody_location">Custody Location</label>
                            <input type="text" class="form-control" id="custody_location" name="custody_location" value="{{ $suspect->custody_location }}">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="custody_notes">Custody Notes</label>
                            <textarea class="form-control" id="custody_notes" name="custody_notes" rows="3"></textarea>
                            <small class="form-text text-muted">Provide details about this custody update</small>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-12">
                        <button type="submit" class="btn btn-warning float-right">Update Custody Status</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Show/hide arrest details based on checkbox
            $('#is_arrested').change(function() {
                if(this.checked) {
                    $('.arrest-details').show();
                } else {
                    $('.arrest-details').hide();
                }
            });
            
            // Show/hide charge details based on checkbox
            $('#is_charged').change(function() {
                if(this.checked) {
                    $('.charge-details').show();
                } else {
                    $('.charge-details').hide();
                }
            });
            
            // Show/hide custody details based on checkbox
            $('#in_custody').change(function() {
                if(this.checked) {
                    $('.custody-details').show();
                } else {
                    $('.custody-details').hide();
                }
            });
            
            // Trigger change events on page load to handle initial state
            $('#is_arrested').trigger('change');
            $('#is_charged').trigger('change');
            $('#in_custody').trigger('change');
            
            // Update file input label with selected filename
            $('.custom-file-input').on('change', function() {
                let fileName = $(this).val().split('\\').pop();
                $(this).next('.custom-file-label').addClass("selected").html(fileName);
            });
        });
    </script>
@stop
