@extends('adminlte::page')

@section('title', 'Case Suspects')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Case Suspects</h1>
        <div>
            @if(request()->has('case_id') && request()->case_id)
                <a href="{{ route('case-suspects.create', ['case_id' => request()->case_id]) }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add New Suspect
                </a>
            @else
                <a href="{{ route('case-suspects.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add New Suspect
                </a>
            @endif
        </div>
    </div>
@stop

@section('content')
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Filter Suspects</h3>
            <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                </button>
            </div>
        </div>
        <div class="card-body">
            <form action="{{ route('case-suspects.index') }}" method="GET">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="case_id">Case</label>
                            <select class="form-control" id="case_id" name="case_id">
                                <option value="">All Cases</option>
                                @foreach($cases as $case)
                                    <option value="{{ $case->id }}" {{ request('case_id') == $case->id ? 'selected' : '' }}>
                                        #{{ $case->case_number }} - {{ Str::limit($case->title, 30) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="is_arrested">Arrest Status</label>
                            <select class="form-control" id="is_arrested" name="is_arrested">
                                <option value="">All</option>
                                <option value="1" {{ request('is_arrested') == '1' ? 'selected' : '' }}>Arrested</option>
                                <option value="0" {{ request('is_arrested') == '0' ? 'selected' : '' }}>Not Arrested</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="is_charged">Charge Status</label>
                            <select class="form-control" id="is_charged" name="is_charged">
                                <option value="">All</option>
                                <option value="1" {{ request('is_charged') == '1' ? 'selected' : '' }}>Charged</option>
                                <option value="0" {{ request('is_charged') == '0' ? 'selected' : '' }}>Not Charged</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="search">Search</label>
                            <input type="text" class="form-control" id="search" name="search" value="{{ request('search') }}" placeholder="Name, ID, Alias...">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-primary float-right">
                            <i class="fas fa-search"></i> Filter
                        </button>
                        <a href="{{ route('case-suspects.index') }}" class="btn btn-default float-right mr-2">
                            <i class="fas fa-redo"></i> Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <table class="table table-bordered table-striped" id="suspects-table">
                <thead>
                    <tr>
                        <th>Case</th>
                        <th>Name</th>
                        <th>ID Number</th>
                        <th>Arrested</th>
                        <th>Charged</th>
                        <th>In Custody</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($suspects as $suspect)
                        <tr>
                            <td>
                                <a href="{{ route('cases.show', $suspect->case_id) }}">
                                    #{{ $suspect->case->case_number }}
                                </a>
                            </td>
                            <td>{{ $suspect->first_name }} {{ $suspect->last_name }}</td>
                            <td>{{ $suspect->id_number ?? 'N/A' }}</td>
                            <td>
                                @if($suspect->is_arrested)
                                    <span class="badge badge-success">Yes</span>
                                @else
                                    <span class="badge badge-secondary">No</span>
                                @endif
                            </td>
                            <td>
                                @if($suspect->is_charged)
                                    <span class="badge badge-warning">Yes</span>
                                @else
                                    <span class="badge badge-secondary">No</span>
                                @endif
                            </td>
                            <td>
                                @if($suspect->in_custody)
                                    <span class="badge badge-danger">Yes</span>
                                @else
                                    <span class="badge badge-secondary">No</span>
                                @endif
                            </td>
                            <td>
                                <div class="btn-group">
                                    <a href="{{ route('case-suspects.show', $suspect->id) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('case-suspects.edit', $suspect->id) }}" class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $suspect->id }}">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>

                                <!-- Delete Modal -->
                                <div class="modal fade" id="deleteModal{{ $suspect->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="deleteModalLabel">Delete Suspect</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                Are you sure you want to delete this suspect record for <strong>{{ $suspect->first_name }} {{ $suspect->last_name }}</strong>?
                                                <p class="text-danger mt-2">This action cannot be undone and will permanently delete all associated data.</p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                <form action="{{ route('case-suspects.destroy', $suspect->id) }}" method="POST" style="display: inline-block;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger">Delete Suspect</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center">No suspects found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="d-flex justify-content-center">
        {{ $suspects->appends(request()->query())->links() }}
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            $('#suspects-table').DataTable({
                "paging": false,
                "lengthChange": false,
                "searching": false,
                "ordering": true,
                "info": false,
                "autoWidth": false,
                "responsive": true,
            });
        });
    </script>
@stop
