@extends('adminlte::page')

@section('title', 'Suspect Details')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Suspect Details</h1>
        <div>
            <a href="{{ route('case-suspects.edit', $suspect->id) }}" class="btn btn-warning">
                <i class="fas fa-edit"></i> Edit Suspect
            </a>
            <a href="{{ route('cases.show', $suspect->case_id) }}" class="btn btn-info">
                <i class="fas fa-folder-open"></i> View Case
            </a>
        </div>
    </div>
@stop

@section('content')
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="row">
        <div class="col-md-4">
            <div class="card card-primary card-outline">
                <div class="card-body box-profile">
                    <div class="text-center">
                        @if($suspect->photo_path)
                            <img class="profile-user-img img-fluid img-circle" 
                                src="{{ asset('storage/' . $suspect->photo_path) }}" 
                                alt="Suspect photo">
                        @else
                            <img class="profile-user-img img-fluid img-circle" 
                                src="{{ asset('img/default-profile.png') }}" 
                                alt="Default photo">
                        @endif
                    </div>

                    <h3 class="profile-username text-center">{{ $suspect->first_name }} {{ $suspect->last_name }}</h3>

                    @if($suspect->alias)
                        <p class="text-muted text-center">Alias: {{ $suspect->alias }}</p>
                    @endif

                    <ul class="list-group list-group-unbordered mb-3">
                        <li class="list-group-item">
                            <b>Case</b> <a class="float-right" href="{{ route('cases.show', $suspect->case_id) }}">#{{ $suspect->case->case_number }}</a>
                        </li>
                        <li class="list-group-item">
                            <b>Arrested</b> 
                            <span class="float-right">
                                @if($suspect->is_arrested)
                                    <span class="badge badge-success">Yes</span>
                                @else
                                    <span class="badge badge-secondary">No</span>
                                @endif
                            </span>
                        </li>
                        <li class="list-group-item">
                            <b>Charged</b> 
                            <span class="float-right">
                                @if($suspect->is_charged)
                                    <span class="badge badge-warning">Yes</span>
                                @else
                                    <span class="badge badge-secondary">No</span>
                                @endif
                            </span>
                        </li>
                        <li class="list-group-item">
                            <b>In Custody</b> 
                            <span class="float-right">
                                @if($suspect->in_custody)
                                    <span class="badge badge-danger">Yes</span>
                                @else
                                    <span class="badge badge-secondary">No</span>
                                @endif
                            </span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card">
                <div class="card-header p-2">
                    <ul class="nav nav-pills">
                        <li class="nav-item"><a class="nav-link active" href="#personal" data-toggle="tab">Personal Info</a></li>
                        <li class="nav-item"><a class="nav-link" href="#arrest" data-toggle="tab">Arrest Details</a></li>
                        <li class="nav-item"><a class="nav-link" href="#notes" data-toggle="tab">Notes</a></li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content">
                        <div class="active tab-pane" id="personal">
                            <div class="row">
                                <div class="col-md-6">
                                    <dl>
                                        <dt>Date of Birth</dt>
                                        <dd>{{ $suspect->date_of_birth ? $suspect->date_of_birth->format('d M Y') : 'Not recorded' }}</dd>
                                        
                                        <dt>Gender</dt>
                                        <dd>{{ ucfirst($suspect->gender ?? 'Not recorded') }}</dd>
                                        
                                        <dt>Contact Number</dt>
                                        <dd>{{ $suspect->contact_number ?? 'Not recorded' }}</dd>
                                    </dl>
                                </div>
                                <div class="col-md-6">
                                    <dl>
                                        <dt>ID Type</dt>
                                        <dd>{{ $idTypes[$suspect->id_type] ?? 'Not recorded' }}</dd>
                                        
                                        <dt>ID Number</dt>
                                        <dd>{{ $suspect->id_number ?? 'Not recorded' }}</dd>
                                        
                                        <dt>Address</dt>
                                        <dd>{{ $suspect->address ?? 'Not recorded' }}</dd>
                                    </dl>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane" id="arrest">
                            @if($suspect->is_arrested)
                                <div class="row">
                                    <div class="col-md-6">
                                        <dl>
                                            <dt>Arrest Date</dt>
                                            <dd>{{ $suspect->arrest_date ? $suspect->arrest_date->format('d M Y H:i') : 'Not recorded' }}</dd>
                                            
                                            <dt>Arrest Location</dt>
                                            <dd>{{ $suspect->arrest_location ?? 'Not recorded' }}</dd>
                                        </dl>
                                    </div>
                                    <div class="col-md-6">
                                        <dl>
                                            <dt>Arresting Officer</dt>
                                            <dd>
                                                @if($suspect->arrestingOfficer)
                                                    {{ $suspect->arrestingOfficer->rank }} {{ $suspect->arrestingOfficer->name }}
                                                @else
                                                    Not recorded
                                                @endif
                                            </dd>
                                            
                                            @if($suspect->is_charged)
                                                <dt>Charges</dt>
                                                <dd>{{ $suspect->charges ?? 'Not specified' }}</dd>
                                            @endif
                                        </dl>
                                    </div>
                                </div>
                                
                                @if($suspect->in_custody)
                                    <h5 class="mt-4">Custody Information</h5>
                                    <hr>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <dl>
                                                <dt>Custody Location</dt>
                                                <dd>{{ $suspect->custody_location ?? 'Not recorded' }}</dd>
                                            </dl>
                                        </div>
                                        <div class="col-md-6">
                                            <dl>
                                                <dt>Cell Number</dt>
                                                <dd>{{ $suspect->cell_number ?? 'Not recorded' }}</dd>
                                            </dl>
                                        </div>
                                    </div>
                                @endif
                            @else
                                <div class="alert alert-info">
                                    This suspect has not been arrested.
                                </div>
                            @endif
                        </div>

                        <div class="tab-pane" id="notes">
                            <div class="form-group">
                                @if($suspect->notes)
                                    <div class="p-3 bg-light">
                                        {!! nl2br(e($suspect->notes)) !!}
                                    </div>
                                @else
                                    <div class="alert alert-info">
                                        No notes recorded for this suspect.
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Status History</h3>
                </div>
                <div class="card-body p-0">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Status Change</th>
                                <th>Updated By</th>
                                <th>Notes</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($statusUpdates as $update)
                                <tr>
                                    <td>{{ $update->created_at->format('d M Y H:i') }}</td>
                                    <td>
                                        @if($update->update_type === 'arrest')
                                            <span class="badge badge-success">Arrest Status</span>
                                        @elseif($update->update_type === 'charge')
                                            <span class="badge badge-warning">Charge Status</span>
                                        @elseif($update->update_type === 'custody')
                                            <span class="badge badge-danger">Custody Status</span>
                                        @else
                                            <span class="badge badge-info">{{ ucfirst($update->update_type) }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $update->officer->name }}</td>
                                    <td>{{ $update->description }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="text-center">No status updates recorded.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
    <style>
        .profile-user-img {
            width: 150px;
            height: 150px;
            object-fit: cover;
        }
    </style>
@stop

@section('js')
    <script>
        console.log('Suspect details page loaded!');
    </script>
@stop
