@extends('adminlte::page')

@section('title', 'Edit Case Update')

@section('content_header')
    <h1>Edit Case Update</h1>
@stop

@section('content')
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <form action="{{ route('case-updates.update', $update->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="case_id">Case <span class="text-danger">*</span></label>
                            <select class="form-control @error('case_id') is-invalid @enderror" id="case_id" name="case_id" required>
                                <option value="">-- Select Case --</option>
                                @foreach($cases as $case)
                                    <option value="{{ $case->id }}" {{ old('case_id', $update->case_id) == $case->id ? 'selected' : '' }}>
                                        #{{ $case->case_number }} - {{ $case->title }}
                                    </option>
                                @endforeach
                            </select>
                            @error('case_id')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="update_type">Update Type <span class="text-danger">*</span></label>
                            <select class="form-control @error('update_type') is-invalid @enderror" id="update_type" name="update_type" required>
                                <option value="">-- Select Type --</option>
                                @foreach($updateTypes as $key => $value)
                                    <option value="{{ $key }}" {{ old('update_type', $update->update_type) == $key ? 'selected' : '' }}>
                                        {{ $value }}
                                    </option>
                                @endforeach
                            </select>
                            @error('update_type')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="update_date">Update Date <span class="text-danger">*</span></label>
                            <input type="datetime-local" class="form-control @error('update_date') is-invalid @enderror" id="update_date" name="update_date" value="{{ old('update_date', $update->update_date->format('Y-m-d\TH:i')) }}" required>
                            @error('update_date')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="description">Description <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="5" required>{{ old('description', $update->description) }}</textarea>
                            @error('description')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="attachment">Attachment</label>
                            @if($update->attachment_path)
                                <div class="mb-2">
                                    <p>Current attachment: 
                                        <a href="{{ route('case-updates.download', $update->id) }}" target="_blank">
                                            {{ basename($update->attachment_path) }}
                                        </a>
                                    </p>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="remove_attachment" name="remove_attachment" value="1">
                                        <label class="custom-control-label" for="remove_attachment">Remove current attachment</label>
                                    </div>
                                </div>
                            @endif
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('attachment') is-invalid @enderror" id="attachment" name="attachment">
                                    <label class="custom-file-label" for="attachment">Choose new file</label>
                                </div>
                            </div>
                            <small class="form-text text-muted">Accepted formats: PDF, DOC, DOCX, XLS, XLSX, JPG, PNG. Max size: 10MB</small>
                            @error('attachment')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-12">
                        <a href="{{ url()->previous() }}" class="btn btn-secondary">Cancel</a>
                        <button type="submit" class="btn btn-primary float-right">Update</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Update file input label with selected filename
            $('.custom-file-input').on('change', function() {
                let fileName = $(this).val().split('\\').pop();
                $(this).next('.custom-file-label').addClass("selected").html(fileName);
            });
        });
    </script>
@stop
