@extends('adminlte::page')

@section('title', 'Case Updates')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Case Updates</h1>
        <div>
            @if(request()->has('case_id') && request()->case_id)
                <a href="{{ route('case-updates.create', ['case_id' => request()->case_id]) }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add New Update
                </a>
            @else
                <a href="{{ route('case-updates.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add New Update
                </a>
            @endif
        </div>
    </div>
@stop

@section('content')
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Filter Updates</h3>
            <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                </button>
            </div>
        </div>
        <div class="card-body">
            <form action="{{ route('case-updates.index') }}" method="GET">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="case_id">Case</label>
                            <select class="form-control" id="case_id" name="case_id">
                                <option value="">All Cases</option>
                                @foreach($cases as $case)
                                    <option value="{{ $case->id }}" {{ request('case_id') == $case->id ? 'selected' : '' }}>
                                        #{{ $case->case_number }} - {{ Str::limit($case->title, 30) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="update_type">Update Type</label>
                            <select class="form-control" id="update_type" name="update_type">
                                <option value="">All Types</option>
                                @foreach($updateTypes as $key => $value)
                                    <option value="{{ $key }}" {{ request('update_type') == $key ? 'selected' : '' }}>
                                        {{ $value }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="officer_id">Officer</label>
                            <select class="form-control" id="officer_id" name="officer_id">
                                <option value="">All Officers</option>
                                @foreach($officers as $officer)
                                    <option value="{{ $officer->id }}" {{ request('officer_id') == $officer->id ? 'selected' : '' }}>
                                        {{ $officer->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="search">Search</label>
                            <input type="text" class="form-control" id="search" name="search" value="{{ request('search') }}" placeholder="Search in description...">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="start_date">From Date</label>
                            <input type="date" class="form-control" id="start_date" name="start_date" value="{{ request('start_date') }}">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="end_date">To Date</label>
                            <input type="date" class="form-control" id="end_date" name="end_date" value="{{ request('end_date') }}">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group" style="margin-top: 32px;">
                            <button type="submit" class="btn btn-primary float-right">
                                <i class="fas fa-search"></i> Filter
                            </button>
                            <a href="{{ route('case-updates.index') }}" class="btn btn-default float-right mr-2">
                                <i class="fas fa-redo"></i> Reset
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="timeline">
                @forelse ($updates as $update)
                    <div class="time-label">
                        <span class="bg-primary">{{ $update->update_date->format('d M Y') }}</span>
                    </div>
                    <div>
                        @switch($update->update_type)
                            @case('general')
                                <i class="fas fa-info bg-info"></i>
                                @break
                            @case('statement')
                                <i class="fas fa-microphone bg-warning"></i>
                                @break
                            @case('evidence')
                                <i class="fas fa-box bg-success"></i>
                                @break
                            @case('suspect')
                                <i class="fas fa-user-secret bg-danger"></i>
                                @break
                            @case('victim')
                                <i class="fas fa-user-injured bg-purple"></i>
                                @break
                            @case('status')
                                <i class="fas fa-exchange-alt bg-orange"></i>
                                @break
                            @case('court')
                                <i class="fas fa-gavel bg-maroon"></i>
                                @break
                            @case('investigation')
                                <i class="fas fa-search bg-navy"></i>
                                @break
                            @default
                                <i class="fas fa-clipboard bg-gray"></i>
                        @endswitch
                        <div class="timeline-item">
                            <span class="time"><i class="fas fa-clock"></i> {{ $update->update_date->format('H:i') }}</span>
                            <h3 class="timeline-header">
                                <a href="{{ route('cases.show', $update->case_id) }}">Case #{{ $update->case->case_number }}</a>
                                <span class="badge badge-{{ $update->update_type == 'general' ? 'info' : ($update->update_type == 'statement' ? 'warning' : ($update->update_type == 'evidence' ? 'success' : ($update->update_type == 'suspect' ? 'danger' : ($update->update_type == 'victim' ? 'purple' : ($update->update_type == 'status' ? 'orange' : ($update->update_type == 'court' ? 'maroon' : ($update->update_type == 'investigation' ? 'navy' : 'secondary'))))))) }}">
                                    {{ $updateTypes[$update->update_type] ?? ucfirst($update->update_type) }}
                                </span>
                                by <strong>{{ $update->officer->name }}</strong>
                            </h3>
                            <div class="timeline-body">
                                {!! nl2br(e($update->description)) !!}
                            </div>
                            <div class="timeline-footer">
                                @if($update->attachment_path)
                                    <a href="{{ route('case-updates.download', $update->id) }}" class="btn btn-sm btn-primary">
                                        <i class="fas fa-download"></i> Download Attachment
                                    </a>
                                @endif
                                
                                @if(Auth::id() == $update->officer_id || Auth::user()->is_admin)
                                    <a href="{{ route('case-updates.edit', $update->id) }}" class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                    <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $update->id }}">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    <!-- Delete Modal -->
                    <div class="modal fade" id="deleteModal{{ $update->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="deleteModalLabel">Delete Case Update</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    Are you sure you want to delete this case update?
                                    <p class="text-danger mt-2">This action cannot be undone.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                    <form action="{{ route('case-updates.destroy', $update->id) }}" method="POST" style="display: inline-block;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger">Delete Update</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="alert alert-info">
                        <i class="icon fas fa-info"></i> No case updates found.
                    </div>
                @endforelse
                
                <div>
                    <i class="fas fa-clock bg-gray"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="d-flex justify-content-center">
        {{ $updates->appends(request()->query())->links() }}
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
    <style>
        .timeline-item {
            box-shadow: 0 0 1px rgba(0,0,0,.125), 0 1px 3px rgba(0,0,0,.2);
        }
        .badge-purple {
            background-color: #6f42c1;
            color: #fff;
        }
        .badge-orange {
            background-color: #fd7e14;
            color: #fff;
        }
        .badge-maroon {
            background-color: #d81b60;
            color: #fff;
        }
        .badge-navy {
            background-color: #001f3f;
            color: #fff;
        }
    </style>
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Any custom JS can go here
        });
    </script>
@stop
