@extends('adminlte::page')

@section('title', 'View Case Update')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Case Update Details</h1>
        <div>
            <a href="{{ route('case-updates.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Updates
            </a>
            <a href="{{ route('case-updates.edit', $update->id) }}" class="btn btn-warning">
                <i class="fas fa-edit"></i> Edit
            </a>
            <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal">
                <i class="fas fa-trash"></i> Delete
            </button>
        </div>
    </div>
@stop

@section('content')
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Update Information</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Case</label>
                                <p>
                                    <a href="{{ route('cases.show', $update->case_id) }}">
                                        #{{ $update->case->case_number }} - {{ $update->case->title }}
                                    </a>
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Update Type</label>
                                <p>
                                    @switch($update->update_type)
                                        @case('general')
                                            <span class="badge badge-info">General Update</span>
                                            @break
                                        @case('statement')
                                            <span class="badge badge-primary">Statement</span>
                                            @break
                                        @case('evidence')
                                            <span class="badge badge-warning">Evidence</span>
                                            @break
                                        @case('suspect')
                                            <span class="badge badge-danger">Suspect</span>
                                            @break
                                        @case('victim')
                                            <span class="badge badge-dark">Victim</span>
                                            @break
                                        @case('status')
                                            <span class="badge badge-success">Status Change</span>
                                            @break
                                        @case('court')
                                            <span class="badge badge-secondary">Court Proceedings</span>
                                            @break
                                        @case('investigation')
                                            <span class="badge badge-light">Investigation</span>
                                            @break
                                        @default
                                            <span class="badge badge-secondary">{{ ucfirst($update->update_type) }}</span>
                                    @endswitch
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Update Date</label>
                                <p>{{ $update->update_date->format('d M Y, h:i A') }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Officer</label>
                                <p>{{ $update->officer->rank ?? '' }} {{ $update->officer->name }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Description</label>
                                <div class="p-3 bg-light" style="border-radius: 5px; white-space: pre-wrap;">{{ $update->description }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Attachment</h3>
                </div>
                <div class="card-body">
                    @if($update->attachment_path)
                        <div class="form-group">
                            @php
                                $extension = pathinfo(storage_path('app/public/' . $update->attachment_path), PATHINFO_EXTENSION);
                                $isImage = in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif']);
                                $isPdf = strtolower($extension) === 'pdf';
                            @endphp
                            
                            @if($isImage)
                                <div class="mb-3">
                                    <img src="{{ asset('storage/' . $update->attachment_path) }}" alt="Attachment" class="img-fluid img-thumbnail">
                                </div>
                            @elseif($isPdf)
                                <div class="mb-3">
                                    <div class="embed-responsive embed-responsive-4by3">
                                        <iframe class="embed-responsive-item" src="{{ asset('storage/' . $update->attachment_path) }}"></iframe>
                                    </div>
                                </div>
                            @endif
                            
                            <a href="{{ route('case-updates.download', $update->id) }}" class="btn btn-primary btn-block">
                                <i class="fas fa-download"></i> Download Attachment
                            </a>
                            <p class="text-muted mt-2">
                                <strong>File:</strong> {{ basename($update->attachment_path) }}<br>
                                <strong>Type:</strong> {{ strtoupper($extension) }}
                            </p>
                        </div>
                    @else
                        <p class="text-muted">No attachment for this update.</p>
                    @endif
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Related Information</h3>
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <label>Created</label>
                        <p>{{ $update->created_at->format('d M Y, h:i A') }}</p>
                    </div>
                    
                    <div class="form-group">
                        <label>Last Updated</label>
                        <p>{{ $update->updated_at->format('d M Y, h:i A') }}</p>
                    </div>
                    
                    <a href="{{ route('cases.show', $update->case_id) }}" class="btn btn-info btn-block">
                        <i class="fas fa-folder-open"></i> View Full Case
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Delete Case Update</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this case update?
                    <p class="text-danger mt-2">This action cannot be undone and will permanently delete all associated files.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <form action="{{ route('case-updates.destroy', $update->id) }}" method="POST" style="display: inline-block;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Delete Update</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
    <style>
        .bg-light {
            background-color: #f8f9fa;
        }
    </style>
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Any additional JS can go here
        });
    </script>
@stop
