@extends('adminlte::page')

@section('title', 'Edit Victim')

@section('content_header')
    <h1>Edit Victim</h1>
@stop

@section('content')
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <form action="{{ route('case-victims.update', $victim->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="case_id">Case <span class="text-danger">*</span></label>
                            <select class="form-control @error('case_id') is-invalid @enderror" id="case_id" name="case_id" required>
                                <option value="">-- Select Case --</option>
                                @foreach($cases as $case)
                                    <option value="{{ $case->id }}" {{ old('case_id', $victim->case_id) == $case->id ? 'selected' : '' }}>
                                        #{{ $case->case_number }} - {{ $case->title }}
                                    </option>
                                @endforeach
                            </select>
                            @error('case_id')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="victim_type">Victim Type <span class="text-danger">*</span></label>
                            <select class="form-control @error('victim_type') is-invalid @enderror" id="victim_type" name="victim_type" required>
                                <option value="">-- Select Type --</option>
                                <option value="individual" {{ old('victim_type', $victim->victim_type) == 'individual' ? 'selected' : '' }}>Individual</option>
                                <option value="business" {{ old('victim_type', $victim->victim_type) == 'business' ? 'selected' : '' }}>Business</option>
                                <option value="government" {{ old('victim_type', $victim->victim_type) == 'government' ? 'selected' : '' }}>Government</option>
                                <option value="organization" {{ old('victim_type', $victim->victim_type) == 'organization' ? 'selected' : '' }}>Organization</option>
                            </select>
                            @error('victim_type')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <h4 class="mt-4">Victim Information</h4>
                <hr>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name">Full Name / Entity Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $victim->name) }}" required>
                            @error('name')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6 individual-field">
                        <div class="form-group">
                            <label for="gender">Gender</label>
                            <select class="form-control @error('gender') is-invalid @enderror" id="gender" name="gender">
                                <option value="">-- Select Gender --</option>
                                <option value="male" {{ old('gender', $victim->gender) == 'male' ? 'selected' : '' }}>Male</option>
                                <option value="female" {{ old('gender', $victim->gender) == 'female' ? 'selected' : '' }}>Female</option>
                                <option value="other" {{ old('gender', $victim->gender) == 'other' ? 'selected' : '' }}>Other</option>
                            </select>
                            @error('gender')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row individual-field">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="date_of_birth">Date of Birth</label>
                            <input type="date" class="form-control @error('date_of_birth') is-invalid @enderror" id="date_of_birth" name="date_of_birth" value="{{ old('date_of_birth', $victim->date_of_birth ? $victim->date_of_birth->format('Y-m-d') : '') }}">
                            @error('date_of_birth')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="id_type">ID Type</label>
                            <select class="form-control @error('id_type') is-invalid @enderror" id="id_type" name="id_type">
                                <option value="">-- Select ID Type --</option>
                                <option value="national_id" {{ old('id_type', $victim->id_type) == 'national_id' ? 'selected' : '' }}>National ID</option>
                                <option value="passport" {{ old('id_type', $victim->id_type) == 'passport' ? 'selected' : '' }}>Passport</option>
                                <option value="drivers_license" {{ old('id_type', $victim->id_type) == 'drivers_license' ? 'selected' : '' }}>Driver's License</option>
                                <option value="voter_card" {{ old('id_type', $victim->id_type) == 'voter_card' ? 'selected' : '' }}>Voter's Card</option>
                                <option value="other" {{ old('id_type', $victim->id_type) == 'other' ? 'selected' : '' }}>Other</option>
                            </select>
                            @error('id_type')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6 individual-field">
                        <div class="form-group">
                            <label for="id_number">ID Number</label>
                            <input type="text" class="form-control @error('id_number') is-invalid @enderror" id="id_number" name="id_number" value="{{ old('id_number', $victim->id_number) }}">
                            @error('id_number')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="contact_number">Contact Number</label>
                            <input type="text" class="form-control @error('contact_number') is-invalid @enderror" id="contact_number" name="contact_number" value="{{ old('contact_number', $victim->contact_number) }}">
                            @error('contact_number')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="email">Email Address</label>
                            <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email', $victim->email) }}">
                            @error('email')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6 organization-field" style="display: none;">
                        <div class="form-group">
                            <label for="organization_type">Organization Type</label>
                            <input type="text" class="form-control @error('organization_type') is-invalid @enderror" id="organization_type" name="organization_type" value="{{ old('organization_type', $victim->organization_type) }}">
                            @error('organization_type')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="address">Address</label>
                            <textarea class="form-control @error('address') is-invalid @enderror" id="address" name="address" rows="2">{{ old('address', $victim->address) }}</textarea>
                            @error('address')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <h4 class="mt-4">Incident Details</h4>
                <hr>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="injury_status">Injury Status</label>
                            <select class="form-control @error('injury_status') is-invalid @enderror" id="injury_status" name="injury_status">
                                <option value="">-- Select Status --</option>
                                <option value="none" {{ old('injury_status', $victim->injury_status) == 'none' ? 'selected' : '' }}>None</option>
                                <option value="minor" {{ old('injury_status', $victim->injury_status) == 'minor' ? 'selected' : '' }}>Minor</option>
                                <option value="moderate" {{ old('injury_status', $victim->injury_status) == 'moderate' ? 'selected' : '' }}>Moderate</option>
                                <option value="severe" {{ old('injury_status', $victim->injury_status) == 'severe' ? 'selected' : '' }}>Severe</option>
                                <option value="fatal" {{ old('injury_status', $victim->injury_status) == 'fatal' ? 'selected' : '' }}>Fatal</option>
                            </select>
                            @error('injury_status')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="property_loss">Property Loss</label>
                            <select class="form-control @error('property_loss') is-invalid @enderror" id="property_loss" name="property_loss">
                                <option value="">-- Select Loss --</option>
                                <option value="none" {{ old('property_loss', $victim->property_loss) == 'none' ? 'selected' : '' }}>None</option>
                                <option value="minor" {{ old('property_loss', $victim->property_loss) == 'minor' ? 'selected' : '' }}>Minor</option>
                                <option value="moderate" {{ old('property_loss', $victim->property_loss) == 'moderate' ? 'selected' : '' }}>Moderate</option>
                                <option value="significant" {{ old('property_loss', $victim->property_loss) == 'significant' ? 'selected' : '' }}>Significant</option>
                                <option value="major" {{ old('property_loss', $victim->property_loss) == 'major' ? 'selected' : '' }}>Major</option>
                            </select>
                            @error('property_loss')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="injury_description">Injury/Loss Description</label>
                            <textarea class="form-control @error('injury_description') is-invalid @enderror" id="injury_description" name="injury_description" rows="3">{{ old('injury_description', $victim->injury_description) }}</textarea>
                            @error('injury_description')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="photo">Victim Photo</label>
                            @if($victim->photo_path)
                                <div class="mb-2">
                                    <img src="{{ asset('storage/' . $victim->photo_path) }}" alt="Victim Photo" class="img-thumbnail" style="max-height: 150px;">
                                    <p class="text-muted">Current photo</p>
                                </div>
                                <div class="custom-control custom-checkbox mb-2">
                                    <input type="checkbox" class="custom-control-input" id="remove_photo" name="remove_photo" value="1">
                                    <label class="custom-control-label" for="remove_photo">Remove current photo</label>
                                </div>
                            @endif
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('photo') is-invalid @enderror" id="photo" name="photo">
                                    <label class="custom-file-label" for="photo">Choose new file</label>
                                </div>
                            </div>
                            <small class="form-text text-muted">Accepted formats: JPG, PNG. Max size: 2MB</small>
                            @error('photo')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="evidence_photos">Evidence Photos</label>
                            @if($victim->evidence_photos && count($victim->evidence_photos) > 0)
                                <div class="mb-2">
                                    <div class="row">
                                        @foreach($victim->evidence_photos as $index => $photo)
                                            <div class="col-md-4 mb-2">
                                                <img src="{{ asset('storage/' . $photo) }}" alt="Evidence Photo {{ $index + 1 }}" class="img-thumbnail" style="max-height: 100px;">
                                                <div class="custom-control custom-checkbox mt-1">
                                                    <input type="checkbox" class="custom-control-input" id="remove_evidence_{{ $index }}" name="remove_evidence[]" value="{{ $index }}">
                                                    <label class="custom-control-label" for="remove_evidence_{{ $index }}">Remove</label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('evidence_photos') is-invalid @enderror" id="evidence_photos" name="evidence_photos[]" multiple>
                                    <label class="custom-file-label" for="evidence_photos">Choose new files</label>
                                </div>
                            </div>
                            <small class="form-text text-muted">Multiple files allowed. Accepted formats: JPG, PNG. Max size: 5MB total</small>
                            @error('evidence_photos')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="notes">Additional Notes</label>
                            <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes', $victim->notes) }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-12">
                        <a href="{{ url()->previous() }}" class="btn btn-secondary">Cancel</a>
                        <button type="submit" class="btn btn-primary float-right">Update Victim</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Update file input label with selected filename
            $('.custom-file-input').on('change', function() {
                let fileName = $(this).val().split('\\').pop();
                if ($(this).attr('multiple')) {
                    let fileCount = $(this)[0].files.length;
                    if (fileCount > 1) {
                        $(this).next('.custom-file-label').addClass("selected").html(fileCount + " files selected");
                    } else {
                        $(this).next('.custom-file-label').addClass("selected").html(fileName);
                    }
                } else {
                    $(this).next('.custom-file-label').addClass("selected").html(fileName);
                }
            });
            
            // Toggle fields based on victim type
            function toggleFields() {
                let victimType = $('#victim_type').val();
                
                if (victimType === 'individual') {
                    $('.individual-field').show();
                    $('.organization-field').hide();
                } else if (victimType === 'business' || victimType === 'government' || victimType === 'organization') {
                    $('.individual-field').hide();
                    $('.organization-field').show();
                } else {
                    $('.individual-field').hide();
                    $('.organization-field').hide();
                }
            }
            
            // Initial toggle
            toggleFields();
            
            // Toggle on change
            $('#victim_type').change(function() {
                toggleFields();
            });
        });
    </script>
@stop
