@extends('adminlte::page')

@section('title', 'Case Victims')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Case Victims</h1>
        <div>
            @if(request()->has('case_id') && request()->case_id)
                <a href="{{ route('case-victims.create', ['case_id' => request()->case_id]) }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add New Victim
                </a>
            @else
                <a href="{{ route('case-victims.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add New Victim
                </a>
            @endif
        </div>
    </div>
@stop

@section('content')
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Filter Victims</h3>
            <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                </button>
            </div>
        </div>
        <div class="card-body">
            <form action="{{ route('case-victims.index') }}" method="GET">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="case_id">Case</label>
                            <select class="form-control" id="case_id" name="case_id">
                                <option value="">All Cases</option>
                                @foreach($cases as $case)
                                    <option value="{{ $case->id }}" {{ request('case_id') == $case->id ? 'selected' : '' }}>
                                        #{{ $case->case_number }} - {{ Str::limit($case->title, 30) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="gender">Gender</label>
                            <select class="form-control" id="gender" name="gender">
                                <option value="">All</option>
                                <option value="male" {{ request('gender') == 'male' ? 'selected' : '' }}>Male</option>
                                <option value="female" {{ request('gender') == 'female' ? 'selected' : '' }}>Female</option>
                                <option value="other" {{ request('gender') == 'other' ? 'selected' : '' }}>Other</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="victim_type">Victim Type</label>
                            <select class="form-control" id="victim_type" name="victim_type">
                                <option value="">All Types</option>
                                <option value="individual" {{ request('victim_type') == 'individual' ? 'selected' : '' }}>Individual</option>
                                <option value="business" {{ request('victim_type') == 'business' ? 'selected' : '' }}>Business</option>
                                <option value="government" {{ request('victim_type') == 'government' ? 'selected' : '' }}>Government</option>
                                <option value="organization" {{ request('victim_type') == 'organization' ? 'selected' : '' }}>Organization</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="search">Search</label>
                            <input type="text" class="form-control" id="search" name="search" value="{{ request('search') }}" placeholder="Name, ID, Contact...">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary float-right">
                                <i class="fas fa-search"></i> Filter
                            </button>
                            <a href="{{ route('case-victims.index') }}" class="btn btn-default float-right mr-2">
                                <i class="fas fa-redo"></i> Reset
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <table class="table table-bordered table-striped" id="victims-table">
                <thead>
                    <tr>
                        <th>Case</th>
                        <th>Name</th>
                        <th>Type</th>
                        <th>Contact</th>
                        <th>Injury Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($victims as $victim)
                        <tr>
                            <td>
                                <a href="{{ route('cases.show', $victim->case_id) }}">
                                    #{{ $victim->case->case_number }}
                                </a>
                            </td>
                            <td>{{ $victim->name }}</td>
                            <td>
                                @switch($victim->victim_type)
                                    @case('individual')
                                        <span class="badge badge-info">Individual</span>
                                        @break
                                    @case('business')
                                        <span class="badge badge-primary">Business</span>
                                        @break
                                    @case('government')
                                        <span class="badge badge-danger">Government</span>
                                        @break
                                    @case('organization')
                                        <span class="badge badge-warning">Organization</span>
                                        @break
                                    @default
                                        <span class="badge badge-secondary">{{ ucfirst($victim->victim_type) }}</span>
                                @endswitch
                            </td>
                            <td>{{ $victim->contact_number ?? 'N/A' }}</td>
                            <td>
                                @switch($victim->injury_status)
                                    @case('none')
                                        <span class="badge badge-success">None</span>
                                        @break
                                    @case('minor')
                                        <span class="badge badge-info">Minor</span>
                                        @break
                                    @case('moderate')
                                        <span class="badge badge-warning">Moderate</span>
                                        @break
                                    @case('severe')
                                        <span class="badge badge-danger">Severe</span>
                                        @break
                                    @case('fatal')
                                        <span class="badge badge-dark">Fatal</span>
                                        @break
                                    @default
                                        <span class="badge badge-secondary">Unknown</span>
                                @endswitch
                            </td>
                            <td>
                                <div class="btn-group">
                                    <a href="{{ route('case-victims.show', $victim->id) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('case-victims.edit', $victim->id) }}" class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $victim->id }}">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>

                                <!-- Delete Modal -->
                                <div class="modal fade" id="deleteModal{{ $victim->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="deleteModalLabel">Delete Victim</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                Are you sure you want to delete victim <strong>{{ $victim->name }}</strong> from this case?
                                                <p class="text-danger mt-2">This action cannot be undone and will permanently delete all associated files and records.</p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                <form action="{{ route('case-victims.destroy', $victim->id) }}" method="POST" style="display: inline-block;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger">Delete Victim</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center">No victims found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="d-flex justify-content-center">
        {{ $victims->appends(request()->query())->links() }}
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            $('#victims-table').DataTable({
                "paging": false,
                "lengthChange": false,
                "searching": false,
                "ordering": true,
                "info": false,
                "autoWidth": false,
                "responsive": true,
            });
        });
    </script>
@stop
