@extends('adminlte::page')

@section('title', 'View Victim')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Victim Details</h1>
        <div>
            <a href="{{ route('case-victims.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Victims
            </a>
            <a href="{{ route('case-victims.edit', $victim->id) }}" class="btn btn-warning">
                <i class="fas fa-edit"></i> Edit
            </a>
            <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal">
                <i class="fas fa-trash"></i> Delete
            </button>
        </div>
    </div>
@stop

@section('content')
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Victim Information</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Case</label>
                                <p>
                                    <a href="{{ route('cases.show', $victim->case_id) }}">
                                        #{{ $victim->case->case_number }} - {{ $victim->case->title }}
                                    </a>
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Victim Type</label>
                                <p>
                                    @switch($victim->victim_type)
                                        @case('individual')
                                            <span class="badge badge-info">Individual</span>
                                            @break
                                        @case('business')
                                            <span class="badge badge-primary">Business</span>
                                            @break
                                        @case('government')
                                            <span class="badge badge-danger">Government</span>
                                            @break
                                        @case('organization')
                                            <span class="badge badge-warning">Organization</span>
                                            @break
                                        @default
                                            <span class="badge badge-secondary">{{ ucfirst($victim->victim_type) }}</span>
                                    @endswitch
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Name</label>
                                <p>{{ $victim->name }}</p>
                            </div>
                        </div>
                        @if($victim->victim_type == 'individual')
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Gender</label>
                                    <p>{{ ucfirst($victim->gender ?? 'Not specified') }}</p>
                                </div>
                            </div>
                        @endif
                    </div>
                    
                    @if($victim->victim_type == 'individual')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Date of Birth</label>
                                    <p>{{ $victim->date_of_birth ? $victim->date_of_birth->format('d M Y') : 'Not specified' }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>ID Information</label>
                                    @if($victim->id_type && $victim->id_number)
                                        <p>{{ ucfirst(str_replace('_', ' ', $victim->id_type)) }}: {{ $victim->id_number }}</p>
                                    @else
                                        <p>Not provided</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endif
                    
                    @if($victim->victim_type != 'individual' && $victim->organization_type)
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Organization Type</label>
                                    <p>{{ $victim->organization_type }}</p>
                                </div>
                            </div>
                        </div>
                    @endif
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Contact Number</label>
                                <p>{{ $victim->contact_number ?? 'Not provided' }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Email Address</label>
                                <p>{{ $victim->email ?? 'Not provided' }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Address</label>
                                <p>{{ $victim->address ?? 'Not provided' }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <h5>Incident Details</h5>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Injury Status</label>
                                <p>
                                    @switch($victim->injury_status)
                                        @case('none')
                                            <span class="badge badge-success">None</span>
                                            @break
                                        @case('minor')
                                            <span class="badge badge-info">Minor</span>
                                            @break
                                        @case('moderate')
                                            <span class="badge badge-warning">Moderate</span>
                                            @break
                                        @case('severe')
                                            <span class="badge badge-danger">Severe</span>
                                            @break
                                        @case('fatal')
                                            <span class="badge badge-dark">Fatal</span>
                                            @break
                                        @default
                                            <span class="badge badge-secondary">Not specified</span>
                                    @endswitch
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Property Loss</label>
                                <p>
                                    @switch($victim->property_loss)
                                        @case('none')
                                            <span class="badge badge-success">None</span>
                                            @break
                                        @case('minor')
                                            <span class="badge badge-info">Minor</span>
                                            @break
                                        @case('moderate')
                                            <span class="badge badge-warning">Moderate</span>
                                            @break
                                        @case('significant')
                                            <span class="badge badge-danger">Significant</span>
                                            @break
                                        @case('major')
                                            <span class="badge badge-dark">Major</span>
                                            @break
                                        @default
                                            <span class="badge badge-secondary">Not specified</span>
                                    @endswitch
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    @if($victim->injury_description)
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Injury/Loss Description</label>
                                    <div class="p-3 bg-light" style="border-radius: 5px;">{{ $victim->injury_description }}</div>
                                </div>
                            </div>
                        </div>
                    @endif
                    
                    @if($victim->notes)
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Additional Notes</label>
                                    <div class="p-3 bg-light" style="border-radius: 5px;">{{ $victim->notes }}</div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
            
            @if(!empty($victim->evidence_photos) && is_array($victim->evidence_photos) && count($victim->evidence_photos) > 0)
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Evidence Photos</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @foreach($victim->evidence_photos as $photo)
                                <div class="col-md-4 mb-3">
                                    <a href="{{ asset('storage/' . $photo) }}" target="_blank">
                                        <img src="{{ asset('storage/' . $photo) }}" alt="Evidence Photo" class="img-fluid img-thumbnail">
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            @endif
        </div>
        
        <div class="col-md-4">
            @if($victim->photo_path)
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Victim Photo</h3>
                    </div>
                    <div class="card-body text-center">
                        <img src="{{ asset('storage/' . $victim->photo_path) }}" alt="Victim Photo" class="img-fluid img-thumbnail">
                    </div>
                </div>
            @endif
            
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Related Information</h3>
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <label>Added On</label>
                        <p>{{ $victim->created_at->format('d M Y, h:i A') }}</p>
                    </div>
                    
                    <div class="form-group">
                        <label>Last Updated</label>
                        <p>{{ $victim->updated_at->format('d M Y, h:i A') }}</p>
                    </div>
                    
                    <div class="form-group">
                        <label>Added By</label>
                        <p>{{ $victim->created_by_user->name ?? 'Unknown' }}</p>
                    </div>
                    
                    <hr>
                    
                    <div class="form-group">
                        <a href="{{ route('cases.show', $victim->case_id) }}" class="btn btn-info btn-block">
                            <i class="fas fa-folder-open"></i> View Full Case
                        </a>
                    </div>
                    
                    <div class="form-group">
                        <a href="{{ route('case-statements.create', ['case_id' => $victim->case_id, 'statement_type' => 'victim', 'given_by_name' => $victim->name]) }}" class="btn btn-primary btn-block">
                            <i class="fas fa-microphone"></i> Record Statement
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Delete Victim</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete victim <strong>{{ $victim->name }}</strong> from this case?
                    <p class="text-danger mt-2">This action cannot be undone and will permanently delete all associated files and records.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <form action="{{ route('case-victims.destroy', $victim->id) }}" method="POST" style="display: inline-block;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Delete Victim</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
    <style>
        .bg-light {
            background-color: #f8f9fa;
        }
    </style>
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Any additional JS can go here
        });
    </script>
@stop
