@extends('adminlte::page')

@section('title', 'Create New Case')

@section('content_header')
    <h1>Create New Case</h1>
@stop

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Case Details</h3>
            </div>
            
            <form method="POST" action="{{ route('cases.store') }}" enctype="multipart/form-data">
                @csrf
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="title">Case Title <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title" value="{{ old('title') }}" placeholder="Enter case title" required>
                                @error('title')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="case_number">Case Number</label>
                                <input type="text" class="form-control @error('case_number') is-invalid @enderror" id="case_number" name="case_number" value="{{ old('case_number') }}" placeholder="System will generate if left blank">
                                @error('case_number')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="station_id">Police Station <span class="text-danger">*</span></label>
                                <select class="form-control @error('station_id') is-invalid @enderror" id="station_id" name="station_id" required>
                                    <option value="">Select Station</option>
                                    @foreach($stations as $station)
                                        <option value="{{ $station->id }}" {{ old('station_id') == $station->id ? 'selected' : '' }}>{{ $station->name }}</option>
                                    @endforeach
                                </select>
                                @error('station_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="crime_type">Crime Type <span class="text-danger">*</span></label>
                                <select class="form-control @error('crime_type') is-invalid @enderror" id="crime_type" name="crime_type" required>
                                    <option value="">Select Crime Type</option>
                                    @foreach($crimeTypes as $key => $value)
                                        <option value="{{ $key }}" {{ old('crime_type') == $key ? 'selected' : '' }}>{{ $value }}</option>
                                    @endforeach
                                </select>
                                @error('crime_type')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="incident_date">Incident Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control @error('incident_date') is-invalid @enderror" id="incident_date" name="incident_date" value="{{ old('incident_date') }}" required>
                                @error('incident_date')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="incident_location">Incident Location <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('incident_location') is-invalid @enderror" id="incident_location" name="incident_location" value="{{ old('incident_location') }}" placeholder="Enter location of incident" required>
                                @error('incident_location')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="assigned_officer_id">Assigned Officer <span class="text-danger">*</span></label>
                                <select class="form-control @error('assigned_officer_id') is-invalid @enderror" id="assigned_officer_id" name="assigned_officer_id" required>
                                    <option value="">Select Officer</option>
                                    @foreach($officers as $officer)
                                        <option value="{{ $officer->id }}" {{ old('assigned_officer_id') == $officer->id ? 'selected' : '' }}>{{ $officer->name }} ({{ $officer->badge_number ?? 'No Badge' }})</option>
                                    @endforeach
                                </select>
                                @error('assigned_officer_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="status">Status <span class="text-danger">*</span></label>
                                <select class="form-control @error('status') is-invalid @enderror" id="status" name="status" required>
                                    @foreach($statuses as $key => $value)
                                        <option value="{{ $key }}" {{ old('status', 'open') == $key ? 'selected' : '' }}>{{ $value }}</option>
                                    @endforeach
                                </select>
                                @error('status')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="priority">Priority <span class="text-danger">*</span></label>
                                <select class="form-control @error('priority') is-invalid @enderror" id="priority" name="priority" required>
                                    @foreach($priorities as $key => $value)
                                        <option value="{{ $key }}" {{ old('priority', 'medium') == $key ? 'selected' : '' }}>{{ $value }}</option>
                                    @endforeach
                                </select>
                                @error('priority')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="report_date">Report Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control @error('report_date') is-invalid @enderror" id="report_date" name="report_date" value="{{ old('report_date', date('Y-m-d')) }}" required>
                                @error('report_date')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="attachments">Case Documents</label>
                                <div class="input-group">
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input @error('attachments.*') is-invalid @enderror" id="attachments" name="attachments[]" multiple>
                                        <label class="custom-file-label" for="attachments">Choose files</label>
                                    </div>
                                </div>
                                <small class="text-muted">Upload relevant documents (PDF, DOC, DOCX, XLS, XLSX, TXT)</small>
                                @error('attachments.*')
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="description">Case Description <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="5" placeholder="Enter detailed case description" required>{{ old('description') }}</textarea>
                                @error('description')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Create Case</button>
                    <a href="{{ route('cases.index') }}" class="btn btn-default float-right">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Initialize file input display
            bsCustomFileInput.init();
            
            // Set today's date as default for report date
            if (!$('#report_date').val()) {
                $('#report_date').val(new Date().toISOString().substr(0, 10));
            }
        });
    </script>
@stop
