@extends('adminlte::page')

@section('title', 'Case Management')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Case Management</h1>
        <a href="{{ route('cases.create') }}" class="btn btn-primary">Create New Case</a>
    </div>
@stop

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Filter Cases</h3>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('cases.index') }}" method="GET">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="station_id">Police Station</label>
                                <select class="form-control" id="station_id" name="station_id">
                                    <option value="">All Stations</option>
                                    @foreach($stations as $station)
                                        <option value="{{ $station->id }}" {{ request('station_id') == $station->id ? 'selected' : '' }}>{{ $station->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="status">Status</label>
                                <select class="form-control" id="status" name="status">
                                    <option value="">All Statuses</option>
                                    @foreach($statuses as $key => $value)
                                        <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>{{ $value }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="crime_type">Crime Type</label>
                                <select class="form-control" id="crime_type" name="crime_type">
                                    <option value="">All Crime Types</option>
                                    @foreach($crimeTypes as $key => $value)
                                        <option value="{{ $key }}" {{ request('crime_type') == $key ? 'selected' : '' }}>{{ $value }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="priority">Priority</label>
                                <select class="form-control" id="priority" name="priority">
                                    <option value="">All Priorities</option>
                                    @foreach($priorities as $key => $value)
                                        <option value="{{ $key }}" {{ request('priority') == $key ? 'selected' : '' }}>{{ $value }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="date_from">Date From</label>
                                <input type="date" class="form-control" id="date_from" name="date_from" value="{{ request('date_from') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="date_to">Date To</label>
                                <input type="date" class="form-control" id="date_to" name="date_to" value="{{ request('date_to') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="search">Search</label>
                                <input type="text" class="form-control" id="search" name="search" placeholder="Search by case number, title..." value="{{ request('search') }}">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12 text-right">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search"></i> Filter
                            </button>
                            <a href="{{ route('cases.index') }}" class="btn btn-default">
                                <i class="fas fa-sync"></i> Reset
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Cases List</h3>
            </div>
            <div class="card-body table-responsive p-0">
                <table class="table table-hover text-nowrap">
                    <thead>
                        <tr>
                            <th>Case Number</th>
                            <th>Title</th>
                            <th>Station</th>
                            <th>Crime Type</th>
                            <th>Status</th>
                            <th>Priority</th>
                            <th>Assigned Officer</th>
                            <th>Report Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($cases as $case)
                            <tr>
                                <td>{{ $case->case_number }}</td>
                                <td>{{ $case->title }}</td>
                                <td>{{ $case->station->name ?? 'N/A' }}</td>
                                <td>
                                    @if(isset($crimeTypes[$case->crime_type]))
                                        <span class="badge badge-info">{{ $crimeTypes[$case->crime_type] }}</span>
                                    @else
                                        <span class="badge badge-secondary">Unknown</span>
                                    @endif
                                </td>
                                <td>
                                    @if($case->status == 'open')
                                        <span class="badge badge-success">Open</span>
                                    @elseif($case->status == 'under_investigation')
                                        <span class="badge badge-primary">Under Investigation</span>
                                    @elseif($case->status == 'pending_review')
                                        <span class="badge badge-warning">Pending Review</span>
                                    @elseif($case->status == 'closed')
                                        <span class="badge badge-secondary">Closed</span>
                                    @elseif($case->status == 'reopened')
                                        <span class="badge badge-info">Reopened</span>
                                    @elseif($case->status == 'archived')
                                        <span class="badge badge-dark">Archived</span>
                                    @else
                                        <span class="badge badge-light">{{ $case->status }}</span>
                                    @endif
                                </td>
                                <td>
                                    @if($case->priority == 'high')
                                        <span class="badge badge-danger">High</span>
                                    @elseif($case->priority == 'medium')
                                        <span class="badge badge-warning">Medium</span>
                                    @elseif($case->priority == 'low')
                                        <span class="badge badge-info">Low</span>
                                    @else
                                        <span class="badge badge-light">{{ $case->priority }}</span>
                                    @endif
                                </td>
                                <td>{{ $case->leadInvestigator->name ?? 'Unassigned' }}</td>
                                <td>{{ $case->report_date ? date('Y-m-d', strtotime($case->report_date)) : 'N/A' }}</td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('cases.show', $case->id) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('cases.edit', $case->id) }}" class="btn btn-sm btn-warning">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $case->id }}">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                    
                                    <!-- Delete Modal -->
                                    <div class="modal fade" id="deleteModal{{ $case->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $case->id }}" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deleteModalLabel{{ $case->id }}">Confirm Delete</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    Are you sure you want to delete case <strong>{{ $case->case_number }}</strong>? This action cannot be undone.
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                    <form action="{{ route('cases.destroy', $case->id) }}" method="POST" style="display: inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger">Delete</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="text-center">No cases found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="card-footer clearfix">
                {{ $cases->appends(request()->query())->links() }}
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Enable tooltips
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
@stop
