@extends('adminlte::page')

@section('title', 'View Case')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Case Details: {{ $case->case_number }}</h1>
        <div>
            <a href="{{ route('case-reports.index', ['case_id' => $case->id]) }}" class="btn btn-primary">
                <i class="fas fa-file-alt"></i> Generate Report
            </a>
            <a href="{{ route('cases.edit', $case->id) }}" class="btn btn-warning">
                <i class="fas fa-edit"></i> Edit Case
            </a>
            <a href="{{ route('cases.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to List
            </a>
        </div>
    </div>
@stop

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    {{ $case->title }}
                </h3>
                <div class="card-tools">
                    @if($case->status == 'open')
                        <span class="badge badge-success">Open</span>
                    @elseif($case->status == 'under_investigation')
                        <span class="badge badge-primary">Under Investigation</span>
                    @elseif($case->status == 'pending_review')
                        <span class="badge badge-warning">Pending Review</span>
                    @elseif($case->status == 'closed')
                        <span class="badge badge-secondary">Closed</span>
                    @elseif($case->status == 'reopened')
                        <span class="badge badge-info">Reopened</span>
                    @elseif($case->status == 'archived')
                        <span class="badge badge-dark">Archived</span>
                    @else
                        <span class="badge badge-light">{{ $case->status }}</span>
                    @endif
                    
                    @if($case->priority == 'high')
                        <span class="badge badge-danger">High Priority</span>
                    @elseif($case->priority == 'medium')
                        <span class="badge badge-warning">Medium Priority</span>
                    @elseif($case->priority == 'low')
                        <span class="badge badge-info">Low Priority</span>
                    @else
                        <span class="badge badge-light">{{ $case->priority }} Priority</span>
                    @endif
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <dl>
                            <dt>Case Number</dt>
                            <dd>{{ $case->case_number }}</dd>
                            
                            <dt>Police Station</dt>
                            <dd>{{ $case->station->name ?? 'N/A' }}</dd>
                            
                            <dt>Crime Type</dt>
                            <dd>{{ $crimeTypes[$case->crime_type] ?? 'Unknown' }}</dd>
                            
                            <dt>Incident Date</dt>
                            <dd>{{ $case->incident_date ? date('Y-m-d', strtotime($case->incident_date)) : 'N/A' }}</dd>
                            
                            <dt>Incident Location</dt>
                            <dd>{{ $case->incident_location ?? 'N/A' }}</dd>
                        </dl>
                    </div>
                    <div class="col-md-6">
                        <dl>
                            <dt>Assigned Officer</dt>
                            <dd>{{ $case->assignedOfficer->name ?? 'Unassigned' }}</dd>
                            
                            <dt>Report Date</dt>
                            <dd>{{ $case->report_date ? date('Y-m-d', strtotime($case->report_date)) : 'N/A' }}</dd>
                            
                            <dt>Created By</dt>
                            <dd>{{ $case->createdByUser->name ?? 'System' }} on {{ $case->created_at->format('Y-m-d H:i') }}</dd>
                            
                            <dt>Last Updated</dt>
                            <dd>{{ $case->updated_at->format('Y-m-d H:i') }}</dd>
                            
                            <dt>Last Updated By</dt>
                            <dd>{{ $case->updatedByUser->name ?? 'System' }}</dd>
                        </dl>
                    </div>
                </div>
                
                <div class="row mt-3">
                    <div class="col-md-12">
                        <h5>Case Description</h5>
                        <div class="p-3 bg-light rounded">
                            {!! nl2br(e($case->description)) !!}
                        </div>
                    </div>
                </div>
                
                @if($case->attachments && count(json_decode($case->attachments)) > 0)
                <div class="row mt-4">
                    <div class="col-md-12">
                        <h5>Case Documents</h5>
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>File Name</th>
                                        <th>Type</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach(json_decode($case->attachments) as $attachment)
                                    <tr>
                                        <td>{{ basename($attachment) }}</td>
                                        <td>
                                            @php
                                                $extension = pathinfo($attachment, PATHINFO_EXTENSION);
                                                $icon = 'fa-file';
                                                if(in_array($extension, ['pdf'])) $icon = 'fa-file-pdf';
                                                elseif(in_array($extension, ['doc', 'docx'])) $icon = 'fa-file-word';
                                                elseif(in_array($extension, ['xls', 'xlsx'])) $icon = 'fa-file-excel';
                                                elseif(in_array($extension, ['jpg', 'jpeg', 'png', 'gif'])) $icon = 'fa-file-image';
                                            @endphp
                                            <i class="fas {{ $icon }}"></i> {{ strtoupper($extension) }}
                                        </td>
                                        <td>
                                            <a href="{{ asset('storage/' . $attachment) }}" class="btn btn-sm btn-info" target="_blank">
                                                <i class="fas fa-eye"></i> View
                                            </a>
                                            <a href="{{ asset('storage/' . $attachment) }}" class="btn btn-sm btn-secondary" download>
                                                <i class="fas fa-download"></i> Download
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <!-- Case Components Quick Links -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Case Components</h3>
            </div>
            <div class="card-body p-0">
                <ul class="nav nav-pills flex-column">
                    <li class="nav-item">
                        <a href="{{ route('case-evidences.index', ['case_id' => $case->id]) }}" class="nav-link">
                            <i class="fas fa-fingerprint"></i> Evidence
                            <span class="badge bg-primary float-right">{{ $case->evidences_count ?? 0 }}</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('case-suspects.index', ['case_id' => $case->id]) }}" class="nav-link">
                            <i class="fas fa-user-secret"></i> Suspects
                            <span class="badge bg-primary float-right">{{ $case->suspects_count ?? 0 }}</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('case-victims.index', ['case_id' => $case->id]) }}" class="nav-link">
                            <i class="fas fa-user-injured"></i> Victims
                            <span class="badge bg-primary float-right">{{ $case->victims_count ?? 0 }}</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('case-statements.index', ['case_id' => $case->id]) }}" class="nav-link">
                            <i class="fas fa-comment"></i> Statements
                            <span class="badge bg-primary float-right">{{ $case->statements_count ?? 0 }}</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('case-updates.index', ['case_id' => $case->id]) }}" class="nav-link">
                            <i class="fas fa-history"></i> Updates
                            <span class="badge bg-primary float-right">{{ $case->updates_count ?? 0 }}</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        
        <!-- Recent Updates -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Recent Updates</h3>
                <div class="card-tools">
                    <a href="{{ route('case-updates.index', ['case_id' => $case->id]) }}" class="btn btn-tool">
                        <i class="fas fa-list"></i> View All
                    </a>
                </div>
            </div>
            <div class="card-body p-0">
                <ul class="products-list product-list-in-card pl-2 pr-2">
                    @forelse($case->updates()->latest()->take(5)->get() as $update)
                    <li class="item">
                        <div class="product-info">
                            <a href="{{ route('case-updates.show', $update->id) }}" class="product-title">
                                {{ $update->title }}
                                <span class="badge badge-info float-right">{{ $update->created_at->format('Y-m-d') }}</span>
                            </a>
                            <span class="product-description">
                                {{ Str::limit($update->description, 100) }}
                            </span>
                            <small class="text-muted">By {{ $update->createdByUser->name ?? 'System' }}</small>
                        </div>
                    </li>
                    @empty
                    <li class="item">
                        <div class="product-info text-center py-3">
                            <span class="text-muted">No updates yet</span>
                        </div>
                    </li>
                    @endforelse
                </ul>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Enable tooltips
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
@stop
