@props(['type' => 'data', 'count' => null])

@php
    $user = auth()->user();
@endphp

@if($user && $user->is_officer && !$user->hasMultiStationAccess())
<div class="alert alert-info alert-dismissible">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
    <h5><i class="icon fas fa-filter"></i> Station Data Filter Active</h5>
    
    <p class="mb-1">
        <strong>Showing {{ $type }} from:</strong> {{ $user->station->name ?? 'Your Station' }}
    </p>
    
    @if($count !== null)
    <p class="mb-1">
        <strong>Total {{ $type }} visible:</strong> {{ $count }}
    </p>
    @endif
    
    <small class="text-muted">
        <i class="fas fa-info-circle"></i>
        You are viewing {{ $type }} from your assigned station only. 
        Higher-ranking officers may see {{ $type }} from all stations.
    </small>
</div>
@elseif($user && $user->hasMultiStationAccess())
<div class="alert alert-success alert-dismissible">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
    <h5><i class="icon fas fa-globe"></i> Multi-Station Access</h5>
    
    <p class="mb-1">
        <strong>Showing {{ $type }} from:</strong> All Police Stations
    </p>
    
    @if($count !== null)
    <p class="mb-1">
        <strong>Total {{ $type }} visible:</strong> {{ $count }}
    </p>
    @endif
    
    <small class="text-muted">
        <i class="fas fa-check-circle"></i>
        Your rank allows you to view {{ $type }} from all police stations.
    </small>
</div>
@endif
