@props(['user' => null])

@php
    $user = $user ?? auth()->user();
@endphp

@if($user && $user->is_officer)
<div class="card card-info card-outline">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-building mr-1"></i>
            Station Information
        </h3>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <strong>Assigned Station:</strong>
                <p class="text-muted">
                    {{ $user->station ? $user->station->name : 'No Station Assigned' }}
                </p>
            </div>
            <div class="col-md-6">
                <strong>Data Access Level:</strong>
                <p class="text-muted">
                    @if($user->hasMultiStationAccess())
                        <span class="badge badge-success">
                            <i class="fas fa-globe"></i> All Stations
                        </span>
                    @else
                        <span class="badge badge-info">
                            <i class="fas fa-building"></i> Station Only
                        </span>
                    @endif
                </p>
            </div>
        </div>
        
        @if($user->station)
        <div class="row mt-2">
            <div class="col-md-6">
                <strong>Station Code:</strong>
                <p class="text-muted">{{ $user->station->code ?? 'N/A' }}</p>
            </div>
            <div class="col-md-6">
                <strong>Location:</strong>
                <p class="text-muted">{{ $user->station->location ?? 'N/A' }}</p>
            </div>
        </div>
        @endif

        @if(!$user->hasMultiStationAccess())
        <div class="alert alert-info mt-3">
            <i class="fas fa-info-circle"></i>
            <strong>Note:</strong> You can only view data from your assigned station. 
            Contact your supervisor if you need access to data from other stations.
        </div>
        @endif
    </div>
</div>
@endif
