@extends('adminlte::page')

@section('title', 'Dashboard')

@section('content_header')
    <div class="row">
        <div class="col-sm-6">
            <h1>Dashboard</h1>
        </div>
        <div class="col-sm-6">
            <div class="float-right">
                <span class="badge badge-info p-2">
                    <i class="fas fa-user"></i> {{ $dashboardData['user_info']['rank'] }}
                </span>
                @if($dashboardData['user_info']['badge_number'])
                    <span class="badge badge-secondary p-2 ml-1">
                        <i class="fas fa-id-badge"></i> {{ $dashboardData['user_info']['badge_number'] }}
                    </span>
                @endif
                <span class="badge badge-primary p-2 ml-1">
                    <i class="fas fa-building"></i> {{ $dashboardData['user_info']['station'] }}
                </span>
            </div>
        </div>
    </div>
@stop

@section('content')
    <!-- User Context Information -->
    <div class="row mb-3">
        <div class="col-12">
            <div class="alert alert-info">
                <h5><i class="icon fas fa-info-circle"></i> Your Access Level</h5>
                <p class="mb-1">
                    <strong>Rank:</strong> {{ $dashboardData['user_info']['rank'] }} 
                    (Level {{ $dashboardData['user_info']['rank_level'] }})
                </p>
                <p class="mb-1">
                    <strong>Station Access:</strong> 
                    @if($dashboardData['user_info']['has_multi_station_access'])
                        <span class="badge badge-success">All Stations</span>
                    @else
                        <span class="badge badge-warning">{{ $dashboardData['user_info']['station'] }} Only</span>
                    @endif
                </p>
                <p class="mb-0">
                    <strong>Data Scope:</strong> 
                    @if($dashboardData['user_info']['is_admin'])
                        <span class="badge badge-danger">System Administrator - Full Access</span>
                    @elseif($dashboardData['user_info']['has_multi_station_access'])
                        All police stations and their data
                    @else
                        Limited to {{ $dashboardData['user_info']['station'] }} station data only
                    @endif
                </p>
            </div>
        </div>
    </div>

    <!-- Core Statistics -->
    @if(!empty($stats))
        <div class="row">
            @foreach($stats as $key => $statGroup)
                @if(is_array($statGroup) && isset($statGroup['label']))
                    <!-- Single Stat Card -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-{{ $statGroup['color'] }}">
                            <div class="inner">
                                @if($key === 'cases')
                                    <h3>{{ $statGroup['total'] }}</h3>
                                    <p>{{ $statGroup['label'] }}</p>
                                    <small>
                                        Active: {{ $statGroup['active'] }} | 
                                        Closed: {{ $statGroup['closed'] }} | 
                                        Pending: {{ $statGroup['pending'] }}
                                    </small>
                                @elseif($key === 'evidence')
                                    <h3>{{ $statGroup['total'] }}</h3>
                                    <p>{{ $statGroup['label'] }}</p>
                                    <small>
                                        In Custody: {{ $statGroup['in_custody'] }} | 
                                        In Analysis: {{ $statGroup['in_analysis'] }}
                                    </small>
                                @elseif($key === 'bail')
                                    <h3>{{ $statGroup['pending'] }}</h3>
                                    <p>Pending {{ $statGroup['label'] }}</p>
                                    <small>
                                        Approved: {{ $statGroup['approved'] }} | 
                                        Rejected: {{ $statGroup['rejected'] }} | 
                                        Today's Check-ins: {{ $statGroup['today_checkins'] }}
                                    </small>
                                @else
                                    <h3>{{ $statGroup['total'] }}</h3>
                                    <p>{{ $statGroup['label'] }}</p>
                                @endif
                            </div>
                            <div class="icon">
                                <i class="{{ $statGroup['icon'] }}"></i>
                            </div>
                            <a href="#" class="small-box-footer">
                                View Details <i class="fas fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>
                @endif
            @endforeach
        </div>
    @endif

    <!-- Intelligent Alerts -->
    @if(!empty($alerts))
        <div class="row">
            <div class="col-12">
                <div class="card card-warning">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-exclamation-triangle mr-1"></i>
                            Alerts & Notifications
                        </h3>
                    </div>
                    <div class="card-body">
                        @foreach($alerts as $alert)
                            <div class="alert alert-{{ $alert['type'] }} alert-dismissible">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                <h5>
                                    <i class="icon fas fa-{{ $alert['type'] === 'danger' ? 'ban' : ($alert['type'] === 'warning' ? 'exclamation-triangle' : 'info-circle') }}"></i> 
                                    {{ $alert['title'] }}
                                </h5>
                                <p>{{ $alert['message'] }}</p>
                                @if(isset($alert['action_url']))
                                    <a href="{{ $alert['action_url'] }}" class="btn btn-{{ $alert['type'] }} btn-sm">
                                        Take Action
                                    </a>
                                @endif
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Quick Actions -->
    @if(!empty($quickActions))
        <div class="row">
            <div class="col-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-bolt mr-1"></i>
                            Quick Actions
                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @foreach($quickActions as $action)
                                <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
                                    <a href="{{ $action['url'] }}" class="btn btn-{{ $action['color'] }} btn-block">
                                        <i class="{{ $action['icon'] }}"></i><br>
                                        <small>{{ $action['title'] }}</small>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Rank-Specific Sections -->
    @if(!empty($sections))
        <div class="row">
            @foreach($sections as $sectionKey => $section)
                @if($section['show'])
                    @if($sectionKey === 'my_cases')
                        <!-- My Assigned Cases -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-folder mr-1"></i>
                                        {{ $section['title'] }}
                                    </h3>
                                </div>
                                <div class="card-body p-0">
                                    @if($section['data']->isEmpty())
                                        <div class="alert alert-info m-3">
                                            <i class="fas fa-info-circle"></i> No cases assigned to you.
                                        </div>
                                    @else
                                        <ul class="products-list product-list-in-card pl-2 pr-2">
                                            @foreach($section['data'] as $case)
                                                <li class="item">
                                                    <div class="product-info">
                                                        <a href="{{ route('cases.show', $case->id) }}" class="product-title">
                                                            #{{ $case->case_number }} - {{ $case->title }}
                                                            @switch($case->status)
                                                                @case('active')
                                                                    <span class="badge badge-success float-right">Active</span>
                                                                    @break
                                                                @case('pending')
                                                                    <span class="badge badge-warning float-right">Pending</span>
                                                                    @break
                                                                @case('closed')
                                                                    <span class="badge badge-secondary float-right">Closed</span>
                                                                    @break
                                                                @default
                                                                    <span class="badge badge-dark float-right">{{ ucfirst($case->status) }}</span>
                                                            @endswitch
                                                        </a>
                                                        <span class="product-description">
                                                            {{ Str::limit($case->description, 100) }}
                                                        </span>
                                                        <small class="text-muted">
                                                            <i class="fas fa-calendar"></i> {{ $case->created_at->format('M d, Y') }} |
                                                            <i class="fas fa-building"></i> {{ $case->station->name ?? 'Unknown' }}
                                                        </small>
                                                    </div>
                                                </li>
                                            @endforeach
                                        </ul>
                                    @endif
                                </div>
                                <div class="card-footer text-center">
                                    <a href="{{ route('cases.index', ['assigned_to_me' => true]) }}" class="text-sm">View All My Cases</a>
                                </div>
                            </div>
                        </div>

                    @elseif($sectionKey === 'evidence_status')
                        <!-- Evidence Status Overview -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-box mr-1"></i>
                                        {{ $section['title'] }}
                                    </h3>
                                </div>
                                <div class="card-body">
                                    @if($section['data']->isEmpty())
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle"></i> No evidence data available.
                                        </div>
                                    @else
                                        <div class="row">
                                            @foreach($section['data'] as $status)
                                                <div class="col-6 text-center">
                                                    <div class="info-box">
                                                        <span class="info-box-icon bg-info">
                                                            <i class="fas fa-box"></i>
                                                        </span>
                                                        <div class="info-box-content">
                                                            <span class="info-box-text">{{ ucfirst(str_replace('_', ' ', $status->status)) }}</span>
                                                            <span class="info-box-number">{{ $status->count }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                    @elseif($sectionKey === 'station_overview')
                        <!-- Station Performance -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-chart-line mr-1"></i>
                                        {{ $section['title'] }}
                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-4 text-center">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-primary">
                                                    <i class="fas fa-plus"></i>
                                                </span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Cases This Month</span>
                                                    <span class="info-box-number">{{ $section['data']['cases_this_month'] }}</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-4 text-center">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-success">
                                                    <i class="fas fa-check"></i>
                                                </span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Solved This Month</span>
                                                    <span class="info-box-number">{{ $section['data']['solved_this_month'] }}</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-4 text-center">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-warning">
                                                    <i class="fas fa-percentage"></i>
                                                </span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Clearance Rate</span>
                                                    <span class="info-box-number">{{ $section['data']['clearance_rate'] }}%</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    @elseif($sectionKey === 'bail_management')
                        <!-- Bail Applications Requiring Attention -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-gavel mr-1"></i>
                                        {{ $section['title'] }}
                                    </h3>
                                </div>
                                <div class="card-body p-0">
                                    @if($section['data']->isEmpty())
                                        <div class="alert alert-success m-3">
                                            <i class="fas fa-check-circle"></i> No pending bail applications.
                                        </div>
                                    @else
                                        <ul class="products-list product-list-in-card pl-2 pr-2">
                                            @foreach($section['data'] as $bail)
                                                <li class="item">
                                                    <div class="product-info">
                                                        <a href="{{ route('bail.show', $bail->id) }}" class="product-title">
                                                            Bail Application #{{ $bail->id }}
                                                            <span class="badge badge-warning float-right">Pending</span>
                                                        </a>
                                                        <span class="product-description">
                                                            Case: #{{ $bail->case->case_number ?? 'Unknown' }} - {{ $bail->case->title ?? 'Unknown Case' }}
                                                        </span>
                                                        <small class="text-muted">
                                                            <i class="fas fa-calendar"></i> Applied {{ $bail->created_at->diffForHumans() }} |
                                                            <i class="fas fa-user"></i> {{ $bail->suspect->name ?? 'Unknown Suspect' }}
                                                        </small>
                                                    </div>
                                                </li>
                                            @endforeach
                                        </ul>
                                    @endif
                                </div>
                                <div class="card-footer text-center">
                                    <a href="{{ route('bail.index', ['status' => 'pending']) }}" class="text-sm">View All Pending Applications</a>
                                </div>
                            </div>
                        </div>

                    @elseif($sectionKey === 'officer_performance')
                        <!-- Top Performing Officers -->
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-trophy mr-1"></i>
                                        {{ $section['title'] }}
                                    </h3>
                                </div>
                                <div class="card-body">
                                    @if($section['data']->isEmpty())
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle"></i> No officer performance data available.
                                        </div>
                                    @else
                                        <div class="row">
                                            @foreach($section['data'] as $officer)
                                                <div class="col-md-2 col-sm-4 text-center">
                                                    <div class="position-relative">
                                                        <img src="{{ $officer->adminlte_image() }}" class="img-circle elevation-2" alt="User Image" style="width: 80px; height: 80px; object-fit: cover;">
                                                        <div class="badge badge-success position-absolute" style="top: 0; right: 0;">
                                                            {{ $officer->lead_investigator_cases_count }} cases
                                                        </div>
                                                    </div>
                                                    <h6 class="mt-2">
                                                        <a href="{{ route('officers.show', $officer->id) }}">{{ $officer->name }}</a>
                                                    </h6>
                                                    <small class="text-muted">{{ $officer->rank }}</small>
                                                </div>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                    @elseif($sectionKey === 'multi_station_overview')
                        <!-- Multi-Station Overview -->
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-building mr-1"></i>
                                        {{ $section['title'] }}
                                    </h3>
                                </div>
                                <div class="card-body">
                                    @if($section['data']->isEmpty())
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle"></i> No station data available.
                                        </div>
                                    @else
                                        <div class="row">
                                            @foreach($section['data'] as $station)
                                                <div class="col-md-3 col-sm-6">
                                                    <div class="info-box">
                                                        <span class="info-box-icon bg-info">
                                                            <i class="fas fa-building"></i>
                                                        </span>
                                                        <div class="info-box-content">
                                                            <span class="info-box-text">{{ $station->name }}</span>
                                                            <span class="info-box-number">{{ $station->cases_count }} cases</span>
                                                            <div class="progress">
                                                                <div class="progress-bar" style="width: {{ min(100, ($station->cases_count / max(1, $section['data']->max('cases_count'))) * 100) }}%"></div>
                                                            </div>
                                                            <span class="progress-description">{{ $station->officers_count }} officers</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                    @elseif($sectionKey === 'station_performance_comparison')
                        <!-- Station Performance Comparison (Assistant Superintendent+) -->
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-chart-line mr-1"></i>
                                        {{ $section['title'] }}
                                    </h3>
                                </div>
                                <div class="card-body">
                                    @if($section['data']->isEmpty())
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle"></i> No station performance data available.
                                        </div>
                                    @else
                                        <div class="row">
                                            @foreach($section['data'] as $station)
                                                <div class="col-lg-3 col-md-4 col-sm-6">
                                                    <div class="info-box">
                                                        <span class="info-box-icon bg-{{ $station->clearance_rate >= 70 ? 'success' : ($station->clearance_rate >= 50 ? 'warning' : 'danger') }}">
                                                            <i class="fas fa-building"></i>
                                                        </span>
                                                        <div class="info-box-content">
                                                            <span class="info-box-text">{{ $station->name }}</span>
                                                            <span class="info-box-number">{{ $station->clearance_rate }}%</span>
                                                            <div class="progress">
                                                                <div class="progress-bar bg-{{ $station->clearance_rate >= 70 ? 'success' : ($station->clearance_rate >= 50 ? 'warning' : 'danger') }}" 
                                                                     style="width: {{ $station->clearance_rate }}%"></div>
                                                            </div>
                                                            <span class="progress-description">
                                                                {{ $station->total_cases }} cases | {{ $station->officers }} officers
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                    @elseif($sectionKey === 'critical_cases_attention')
                        <!-- Critical Cases Requiring Attention -->
                        <div class="col-md-6">
                            <div class="card card-danger">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-exclamation-triangle mr-1"></i>
                                        {{ $section['title'] }}
                                    </h3>
                                </div>
                                <div class="card-body p-0">
                                    @if($section['data']->isEmpty())
                                        <div class="alert alert-success m-3">
                                            <i class="fas fa-check-circle"></i> No critical cases requiring immediate attention.
                                        </div>
                                    @else
                                        <ul class="products-list product-list-in-card pl-2 pr-2">
                                            @foreach($section['data'] as $case)
                                                <li class="item">
                                                    <div class="product-info">
                                                        <a href="{{ route('cases.show', $case->id) }}" class="product-title">
                                                            #{{ $case->case_number }} - {{ $case->title }}
                                                            <span class="badge badge-{{ $case->priority === 'high' ? 'danger' : ($case->priority === 'medium' ? 'warning' : 'info') }} float-right">
                                                                {{ ucfirst($case->priority) }} Priority
                                                            </span>
                                                        </a>
                                                        <span class="product-description">
                                                            {{ Str::limit($case->description, 80) }}
                                                        </span>
                                                        <small class="text-muted">
                                                            <i class="fas fa-calendar"></i> {{ $case->created_at->diffForHumans() }} |
                                                            <i class="fas fa-building"></i> {{ $case->station->name ?? 'Unknown' }} |
                                                            <i class="fas fa-user"></i> {{ $case->leadInvestigator->name ?? 'Unassigned' }}
                                                        </small>
                                                    </div>
                                                </li>
                                            @endforeach
                                        </ul>
                                    @endif
                                </div>
                                <div class="card-footer text-center">
                                    <a href="{{ route('cases.index', ['priority' => 'high']) }}" class="text-sm">View All High Priority Cases</a>
                                </div>
                            </div>
                        </div>

                    @elseif($sectionKey === 'resource_allocation_analysis')
                        <!-- Resource Allocation Analysis -->
                        <div class="col-md-6">
                            <div class="card card-info">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-users mr-1"></i>
                                        {{ $section['title'] }}
                                    </h3>
                                </div>
                                <div class="card-body">
                                    @if(isset($section['data']['officer_workload']))
                                        <div class="info-box">
                                            <span class="info-box-icon bg-primary">
                                                <i class="fas fa-user-tie"></i>
                                            </span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Average Officer Workload</span>
                                                <span class="info-box-number">{{ $section['data']['officer_workload'] }} cases</span>
                                            </div>
                                        </div>
                                    @endif

                                    @if(isset($section['data']['evidence_backlog']))
                                        <div class="info-box">
                                            <span class="info-box-icon bg-warning">
                                                <i class="fas fa-box"></i>
                                            </span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Evidence Backlog</span>
                                                <span class="info-box-number">{{ $section['data']['evidence_backlog'] }} items</span>
                                            </div>
                                        </div>
                                    @endif

                                    @if(isset($section['data']['pending_bail']))
                                        <div class="info-box">
                                            <span class="info-box-icon bg-info">
                                                <i class="fas fa-gavel"></i>
                                            </span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Pending Bail Applications</span>
                                                <span class="info-box-number">{{ $section['data']['pending_bail'] }}</span>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                    @elseif($sectionKey === 'monthly_performance_trends')
                        <!-- Monthly Performance Trends -->
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-chart-area mr-1"></i>
                                        {{ $section['title'] }}
                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <!-- Case Resolution Trend -->
                                        @if(isset($section['data']['case_resolution_trend']))
                                            <div class="col-md-4">
                                                <h5>Case Resolution Trend</h5>
                                                <canvas id="caseResolutionChart" width="400" height="200"></canvas>
                                            </div>
                                        @endif

                                        <!-- Crime Type Distribution -->
                                        @if(isset($section['data']['crime_type_distribution']))
                                            <div class="col-md-4">
                                                <h5>Crime Type Distribution</h5>
                                                @foreach($section['data']['crime_type_distribution'] as $crime)
                                                    <div class="progress-group">
                                                        {{ $crime['type'] }}
                                                        <span class="float-right"><b>{{ $crime['count'] }}</b>/{{ $section['data']['crime_type_distribution']->sum('count') }}</span>
                                                        <div class="progress progress-sm">
                                                            <div class="progress-bar bg-primary" style="width: {{ $section['data']['crime_type_distribution']->sum('count') > 0 ? ($crime['count'] / $section['data']['crime_type_distribution']->sum('count')) * 100 : 0 }}%"></div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        @endif

                                        <!-- Station Efficiency Ranking -->
                                        @if(isset($section['data']['station_efficiency_ranking']))
                                            <div class="col-md-4">
                                                <h5>Station Efficiency Ranking</h5>
                                                @foreach($section['data']['station_efficiency_ranking']->take(5) as $index => $station)
                                                    <div class="d-flex justify-content-between align-items-center border-bottom py-2">
                                                        <span class="badge badge-{{ $index < 2 ? 'success' : ($index < 4 ? 'warning' : 'secondary') }} mr-2">{{ $index + 1 }}</span>
                                                        <span class="flex-grow-1">{{ $station->name }}</span>
                                                        <span class="badge badge-primary">{{ $station->efficiency_score }}</span>
                                                    </div>
                                                @endforeach
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                    @elseif($sectionKey === 'operational_alerts')
                        <!-- Operational Alerts -->
                        <div class="col-12">
                            <div class="card card-warning">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-bell mr-1"></i>
                                        {{ $section['title'] }}
                                    </h3>
                                </div>
                                <div class="card-body">
                                    @if(empty($section['data']))
                                        <div class="alert alert-success">
                                            <i class="fas fa-check-circle"></i> No operational alerts at this time.
                                        </div>
                                    @else
                                        <div class="row">
                                            @foreach($section['data'] as $alert)
                                                <div class="col-md-4">
                                                    <div class="alert alert-{{ $alert['type'] }}">
                                                        <h6><i class="fas fa-{{ $alert['icon'] }}"></i> {{ $alert['title'] }}</h6>
                                                        <p class="mb-1">{{ $alert['message'] }}</p>
                                                        @if(isset($alert['count']))
                                                            <span class="badge badge-{{ $alert['type'] }}">{{ $alert['count'] }} affected</span>
                                                        @endif
                                                        @if(isset($alert['action_url']))
                                                            <div class="mt-2">
                                                                <a href="{{ $alert['action_url'] }}" class="btn btn-{{ $alert['type'] }} btn-sm">Take Action</a>
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                    @elseif($sectionKey === 'station_overview')
                        <!-- Station Performance -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-chart-line mr-1"></i>
                                        {{ $section['title'] }}
                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-4 text-center">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-primary">
                                                    <i class="fas fa-plus"></i>
                                                </span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Cases This Month</span>
                                                    <span class="info-box-number">{{ $section['data']['cases_this_month'] }}</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-4 text-center">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-success">
                                                    <i class="fas fa-check"></i>
                                                </span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Solved This Month</span>
                                                    <span class="info-box-number">{{ $section['data']['solved_this_month'] }}</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-4 text-center">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-warning">
                                                    <i class="fas fa-percentage"></i>
                                                </span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Clearance Rate</span>
                                                    <span class="info-box-number">{{ $section['data']['clearance_rate'] }}%</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                @endif
            @endforeach
        </div>
    @endif

    <!-- Recent Activities -->
    @if(!empty($recentActivities))
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-clock mr-1"></i>
                            Recent Activities
                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="timeline">
                            @foreach($recentActivities as $activity)
                                <div class="time-label">
                                    <span class="bg-{{ $activity['color'] }}">{{ $activity['time'] }}</span>
                                </div>
                                <div>
                                    <i class="{{ $activity['icon'] }} bg-{{ $activity['color'] }}"></i>
                                    <div class="timeline-item">
                                        <h3 class="timeline-header">{{ $activity['title'] }}</h3>
                                        <div class="timeline-body">
                                            {{ $activity['description'] }}
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            <!-- Performance Metrics -->
            @if(!empty($performanceMetrics))
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-chart-bar mr-1"></i>
                                Performance Metrics
                            </h3>
                        </div>
                        <div class="card-body">
                            @if(isset($performanceMetrics['case_closure_rate']))
                                <div class="info-box">
                                    <span class="info-box-icon bg-success">
                                        <i class="fas fa-check-circle"></i>
                                    </span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Your Case Closure Rate</span>
                                        <span class="info-box-number">{{ $performanceMetrics['case_closure_rate'] }}%</span>
                                    </div>
                                </div>
                            @endif

                            @if(isset($performanceMetrics['average_case_duration']))
                                <div class="info-box">
                                    <span class="info-box-icon bg-warning">
                                        <i class="fas fa-clock"></i>
                                    </span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Average Case Duration</span>
                                        <span class="info-box-number">{{ $performanceMetrics['average_case_duration'] }} days</span>
                                    </div>
                                </div>
                            @endif

                            @if(isset($performanceMetrics['station_efficiency']))
                                <div class="info-box">
                                    <span class="info-box-icon bg-info">
                                        <i class="fas fa-building"></i>
                                    </span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Station Efficiency</span>
                                        <span class="info-box-number">{{ $performanceMetrics['station_efficiency'] }}%</span>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            @endif
        </div>
    @endif
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
    <style>
        .timeline {
            position: relative;
            margin: 0 0 30px 0;
            padding: 0;
            list-style: none;
        }
        .timeline:before {
            content: '';
            position: absolute;
            top: 0;
            bottom: 0;
            width: 4px;
            background: #ddd;
            left: 31px;
            margin: 0;
            border-radius: 2px;
        }
        .timeline > div {
            margin-bottom: 15px;
            position: relative;
        }
        .timeline > div > .timeline-item {
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            border-radius: 3px;
            margin-top: 0;
            background: #fff;
            color: #444;
            margin-left: 60px;
            margin-right: 15px;
            padding: 0;
            position: relative;
        }
        .timeline > div > .fa,
        .timeline > div > .fas,
        .timeline > div > .far,
        .timeline > div > .fab,
        .timeline > div > .fal,
        .timeline > div > .fad,
        .timeline > div > .icon {
            width: 30px;
            height: 30px;
            font-size: 15px;
            line-height: 30px;
            position: absolute;
            color: #666;
            background: #d2d6de;
            border-radius: 50%;
            text-align: center;
            left: 18px;
            top: 0;
        }
        .timeline-header {
            margin: 0;
            color: #555;
            border-bottom: 1px solid #f4f4f4;
            padding: 10px;
            font-weight: 600;
            font-size: 16px;
        }
        .timeline-body {
            padding: 10px;
        }
        .time-label > span {
            font-weight: 600;
            color: #fff;
            font-size: 12px;
            padding: 5px;
            display: inline-block;
            border-radius: 4px;
        }
    </style>
@stop

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize Case Resolution Trend Chart
            @if(isset($sections['monthly_performance_trends']['data']['case_resolution_trend']))
                var ctx = document.getElementById('caseResolutionChart');
                if (ctx) {
                    var caseResolutionChart = new Chart(ctx, {
                        type: 'line',
                        data: {
                            labels: {!! json_encode($sections['monthly_performance_trends']['data']['case_resolution_trend']['months']) !!},
                            datasets: [{
                                label: 'Total Cases',
                                data: {!! json_encode($sections['monthly_performance_trends']['data']['case_resolution_trend']['total_cases']) !!},
                                borderColor: 'rgb(54, 162, 235)',
                                backgroundColor: 'rgba(54, 162, 235, 0.1)',
                                tension: 0.1
                            }, {
                                label: 'Resolved Cases',
                                data: {!! json_encode($sections['monthly_performance_trends']['data']['case_resolution_trend']['resolved_cases']) !!},
                                borderColor: 'rgb(75, 192, 192)',
                                backgroundColor: 'rgba(75, 192, 192, 0.1)',
                                tension: 0.1
                            }]
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            scales: {
                                y: {
                                    beginAtZero: true
                                }
                            },
                            plugins: {
                                legend: {
                                    position: 'bottom'
                                }
                            }
                        }
                    });
                }
            @endif

            // Auto-refresh dashboard data every 5 minutes
            setInterval(function() {
                if (confirm('Refresh dashboard data?')) {
                    location.reload();
                }
            }, 300000); // 5 minutes

            // Enhanced tooltips for info boxes
            $('[data-toggle="tooltip"]').tooltip();

            // Animate progress bars
            $('.progress-bar').each(function() {
                var width = $(this).css('width');
                $(this).css('width', '0%').animate({
                    width: width
                }, 1000);
            });

            // Add click handlers for quick actions
            $('.quick-action-btn').on('click', function(e) {
                var action = $(this).data('action');
                if (action === 'critical') {
                    // Handle critical action with confirmation
                    if (!confirm('This will take you to critical cases. Continue?')) {
                        e.preventDefault();
                    }
                }
            });

            // Enhanced alert dismissal with fade effect
            $('.alert .close').on('click', function() {
                $(this).closest('.alert').fadeOut(300);
            });

            // Add loading states for action buttons
            $('.btn[href]').on('click', function() {
                var $btn = $(this);
                var originalText = $btn.html();
                $btn.html('<i class="fas fa-spinner fa-spin"></i> Loading...');
                
                setTimeout(function() {
                    $btn.html(originalText);
                }, 2000);
            });
        });

        // Function to format numbers with commas
        function numberWithCommas(x) {
            return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        }

        // Function to update dashboard stats dynamically
        function updateDashboardStats() {
            // This can be enhanced to fetch real-time data via AJAX
            console.log('Dashboard stats updated');
        }

        // Initialize dashboard enhancements
        $(function() {
            // Add hover effects to cards
            $('.card').hover(
                function() {
                    $(this).addClass('shadow-lg').css('transform', 'translateY(-2px)');
                },
                function() {
                    $(this).removeClass('shadow-lg').css('transform', 'translateY(0)');
                }
            );

            // Add click-to-expand functionality for large data sections
            $('.card-header').on('click', function() {
                var $card = $(this).closest('.card');
                var $body = $card.find('.card-body');
                
                if ($card.hasClass('collapsed')) {
                    $body.slideDown();
                    $card.removeClass('collapsed');
                } else if ($card.find('.collapse-toggle').length > 0) {
                    $body.slideUp();
                    $card.addClass('collapsed');
                }
            });
        });
    </script>
@stop
