@extends('adminlte::page')

@section('title', 'Evidence Transfers')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Evidence Transfers</h1>
    </div>
@stop

@section('content')
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>Evidence Transfers</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                <li class="breadcrumb-item active">Evidence Transfers</li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Filter Transfers</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('evidence-transfers.index') }}" method="GET">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="evidence_id">Evidence</label>
                                    <select class="form-control" id="evidence_id" name="evidence_id">
                                        <option value="">All Evidence</option>
                                        @foreach($evidences as $item)
                                            <option value="{{ $item->id }}" {{ request('evidence_id') == $item->id ? 'selected' : '' }}>
                                                {{ $item->tag_number }} - {{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mt-4">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-search"></i> Filter
                                    </button>
                                    <a href="{{ route('evidence-transfers.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-sync"></i> Reset
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Evidence Transfers List</h3>
                    <div class="card-tools">
                        @if($evidence)
                            <a href="{{ route('evidence-transfers.create', ['evidence_id' => $evidence->id]) }}" class="btn btn-sm btn-primary">
                                <i class="fas fa-plus"></i> Record New Transfer for {{ $evidence->tag_number }}
                            </a>
                        @else
                            <a href="{{ route('evidence-transfers.create') }}" class="btn btn-sm btn-primary">
                                <i class="fas fa-plus"></i> Record New Transfer
                            </a>
                        @endif
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover text-nowrap">
                        <thead>
                            <tr>
                                <th>Evidence Tag</th>
                                <th>Transfer Date</th>
                                <th>From</th>
                                <th>To</th>
                                <th>Reason</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($transfers as $transfer)
                                <tr>
                                    <td>
                                        <a href="{{ route('case-evidences.show', $transfer->evidence_id) }}">
                                            {{ $transfer->evidence->tag_number }}
                                        </a>
                                    </td>
                                    <td>{{ \Carbon\Carbon::parse($transfer->transfer_date)->format('M d, Y') }} at {{ $transfer->transfer_time }}</td>
                                    <td>{{ $transfer->from_custodian }}</td>
                                    <td>{{ $transfer->to_custodian }}</td>
                                    <td>{{ $transfer->reason }}</td>
                                    <td>
                                        <form action="{{ route('evidence-transfers.destroy', $transfer->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this transfer record?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center">No transfers found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    {{ $transfers->appends(request()->query())->links() }}
                </div>
            </div>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Enable tooltips
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
@stop
