@extends('adminlte::page')

@section('title', 'Add New Evidence')

@section('content_header')
    <h1>Add New Evidence</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Evidence Details</h3>
        </div>
        <form action="{{ route('evidence.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="card-body">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="tag_number">Tag Number <span class="text-danger">*</span></label>
                            <input type="text" name="tag_number" id="tag_number" class="form-control @error('tag_number') is-invalid @enderror" value="{{ old('tag_number') }}" required>
                            @error('tag_number')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="evidence_type">Evidence Type <span class="text-danger">*</span></label>
                            <select name="evidence_type" id="evidence_type" class="form-control @error('evidence_type') is-invalid @enderror" required>
                                <option value="">Select Type</option>
                                @foreach($evidenceTypes as $value => $label)
                                    <option value="{{ $value }}" {{ old('evidence_type') == $value ? 'selected' : '' }}>{{ $label }}</option>
                                @endforeach
                            </select>
                            @error('evidence_type')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label for="description">Description <span class="text-danger">*</span></label>
                    <textarea name="description" id="description" rows="3" class="form-control @error('description') is-invalid @enderror" required>{{ old('description') }}</textarea>
                    @error('description')
                        <span class="invalid-feedback">{{ $message }}</span>
                    @enderror
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="status">Status <span class="text-danger">*</span></label>
                            <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                @foreach($statuses as $value => $label)
                                    <option value="{{ $value }}" {{ old('status', 'in_custody') == $value ? 'selected' : '' }}>{{ $label }}</option>
                                @endforeach
                            </select>
                            @error('status')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="condition">Condition</label>
                            <input type="text" name="condition" id="condition" class="form-control @error('condition') is-invalid @enderror" value="{{ old('condition') }}">
                            @error('condition')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="location">Location</label>
                            <input type="text" name="location" id="location" class="form-control @error('location') is-invalid @enderror" value="{{ old('location') }}">
                            @error('location')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="storage_location">Storage Location</label>
                            <input type="text" name="storage_location" id="storage_location" class="form-control @error('storage_location') is-invalid @enderror" value="{{ old('storage_location') }}">
                            @error('storage_location')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                <h4 class="mt-4">Collection Information</h4>
                <hr>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="collection_date">Collection Date</label>
                            <input type="datetime-local" name="collection_date" id="collection_date" class="form-control @error('collection_date') is-invalid @enderror" value="{{ old('collection_date') }}">
                            @error('collection_date')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="collection_location">Collection Location</label>
                            <input type="text" name="collection_location" id="collection_location" class="form-control @error('collection_location') is-invalid @enderror" value="{{ old('collection_location') }}">
                            @error('collection_location')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label for="collection_notes">Collection Notes</label>
                    <textarea name="collection_notes" id="collection_notes" rows="2" class="form-control @error('collection_notes') is-invalid @enderror">{{ old('collection_notes') }}</textarea>
                    @error('collection_notes')
                        <span class="invalid-feedback">{{ $message }}</span>
                    @enderror
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="collected_by_officer_id">Collected By</label>
                            <select name="collected_by_officer_id" id="collected_by_officer_id" class="form-control @error('collected_by_officer_id') is-invalid @enderror">
                                <option value="">Select Officer</option>
                                @foreach($officers as $officer)
                                    <option value="{{ $officer->id }}" {{ old('collected_by_officer_id') == $officer->id ? 'selected' : '' }}>{{ $officer->name }}</option>
                                @endforeach
                            </select>
                            @error('collected_by_officer_id')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="custodian">Current Custodian</label>
                            <select name="custodian" id="custodian" class="form-control @error('custodian') is-invalid @enderror">
                                <option value="">Select Officer</option>
                                @foreach($officers as $officer)
                                    <option value="{{ $officer->id }}" {{ old('custodian') == $officer->id ? 'selected' : '' }}>{{ $officer->name }}</option>
                                @endforeach
                            </select>
                            @error('custodian')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label for="case_id">Associated Case (Optional)</label>
                    <input type="text" name="case_id" id="case_id" class="form-control @error('case_id') is-invalid @enderror" value="{{ old('case_id') }}" placeholder="Enter case ID if applicable">
                    @error('case_id')
                        <span class="invalid-feedback">{{ $message }}</span>
                    @enderror
                </div>

                <h4 class="mt-4">Files</h4>
                <hr>

                <div class="form-group">
                    <label for="photos">Photos</label>
                    <div class="custom-file">
                        <input type="file" class="custom-file-input" id="photos" name="photos[]" multiple accept="image/*">
                        <label class="custom-file-label" for="photos">Choose files</label>
                    </div>
                    <small class="form-text text-muted">You can select multiple photos. Accepted formats: JPG, PNG, GIF.</small>
                    @error('photos.*')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="documents">Documents</label>
                    <div class="custom-file">
                        <input type="file" class="custom-file-input" id="documents" name="documents[]" multiple accept=".pdf,.doc,.docx,.xls,.xlsx,.txt">
                        <label class="custom-file-label" for="documents">Choose files</label>
                    </div>
                    <small class="form-text text-muted">You can select multiple documents. Accepted formats: PDF, DOC, DOCX, XLS, XLSX, TXT.</small>
                    @error('documents.*')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
            </div>
            <div class="card-footer">
                <button type="submit" class="btn btn-primary">Save Evidence</button>
                <a href="{{ route('evidence.index') }}" class="btn btn-default float-right">Cancel</a>
            </div>
        </form>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Show file name when selected
            $('.custom-file-input').on('change', function() {
                var fileCount = $(this)[0].files.length;
                if (fileCount > 0) {
                    $(this).next('.custom-file-label').html(fileCount + ' files selected');
                } else {
                    $(this).next('.custom-file-label').html('Choose files');
                }
            });
        });
    </script>
@stop
