@extends('adminlte::page')

@section('title', 'Evidence Details')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Evidence Details</h1>
        <div>
            <a href="{{ route('evidence.edit', $evidence->id) }}" class="btn btn-warning">
                <i class="fas fa-edit mr-1"></i> Edit
            </a>
            <a href="{{ route('evidence.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left mr-1"></i> Back to List
            </a>
        </div>
    </div>
@stop

@section('content')
    @if(session('success'))
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h5><i class="icon fas fa-check"></i> Success!</h5>
            {{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h5><i class="icon fas fa-ban"></i> Error!</h5>
            {{ session('error') }}
        </div>
    @endif

    <div class="row">
        <div class="col-md-8">
            <!-- Evidence Details Card -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-box-open mr-1"></i>
                        Evidence #{{ $evidence->tag_number }}
                    </h3>
                    <div class="card-tools">
                        <span class="badge {{ $evidence->status_badge_class }}">
                            {{ $evidence->status_label }}
                        </span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <dl>
                                <dt>Tag Number</dt>
                                <dd>{{ $evidence->tag_number }}</dd>

                                <dt>Type</dt>
                                <dd>{{ $evidence->evidence_type_label }}</dd>

                                <dt>Status</dt>
                                <dd>
                                    <span class="badge {{ $evidence->status_badge_class }}">
                                        {{ $evidence->status_label }}
                                    </span>
                                </dd>

                                <dt>Condition</dt>
                                <dd>{{ $evidence->condition ?? 'Not specified' }}</dd>

                                <dt>Location</dt>
                                <dd>{{ $evidence->location ?? 'Not specified' }}</dd>

                                <dt>Storage Location</dt>
                                <dd>{{ $evidence->storage_location ?? 'Not specified' }}</dd>
                            </dl>
                        </div>
                        <div class="col-md-6">
                            <dl>
                                <dt>Collection Date</dt>
                                <dd>{{ $evidence->collection_date ? $evidence->collection_date->format('M d, Y H:i') : 'Not specified' }}</dd>

                                <dt>Collection Location</dt>
                                <dd>{{ $evidence->collection_location ?? 'Not specified' }}</dd>

                                <dt>Collected By</dt>
                                <dd>{{ $evidence->collector->name ?? 'Not specified' }}</dd>

                                <dt>Current Custodian</dt>
                                <dd>{{ $evidence->currentCustodian->name ?? 'Not specified' }}</dd>

                                <dt>Associated Case</dt>
                                <dd>
                                    @if($evidence->case)
                                        <a href="{{ route('cases.show', $evidence->case_id) }}">
                                            {{ $evidence->case->case_number }}
                                        </a>
                                    @else
                                        Not associated with any case
                                    @endif
                                </dd>
                            </dl>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-md-12">
                            <h5>Description</h5>
                            <p>{{ $evidence->description }}</p>
                        </div>
                    </div>

                    @if($evidence->collection_notes)
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <h5>Collection Notes</h5>
                                <p>{{ $evidence->collection_notes }}</p>
                            </div>
                        </div>
                    @endif

                    @if($evidence->analysis_date || $evidence->analysis_results)
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <h5>Analysis Information</h5>
                                <dl class="row">
                                    <dt class="col-sm-3">Analysis Date</dt>
                                    <dd class="col-sm-9">{{ $evidence->analysis_date ? $evidence->analysis_date->format('M d, Y H:i') : 'Not specified' }}</dd>

                                    <dt class="col-sm-3">Analyzed By</dt>
                                    <dd class="col-sm-9">{{ $evidence->analyzedByOfficer->name ?? 'Not specified' }}</dd>

                                    <dt class="col-sm-3">Analysis Results</dt>
                                    <dd class="col-sm-9">{{ $evidence->analysis_results ?? 'Not specified' }}</dd>
                                </dl>
                            </div>
                        </div>
                    @endif

                    <div class="row mt-3">
                        <div class="col-md-12">
                            <h5>Record Information</h5>
                            <dl class="row">
                                <dt class="col-sm-3">Created By</dt>
                                <dd class="col-sm-9">{{ $evidence->createdByUser->name ?? 'Unknown' }} on {{ $evidence->created_at->format('M d, Y H:i') }}</dd>

                                <dt class="col-sm-3">Last Updated By</dt>
                                <dd class="col-sm-9">{{ $evidence->updatedByUser->name ?? 'Unknown' }} on {{ $evidence->updated_at->format('M d, Y H:i') }}</dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Chain of Custody Card -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-exchange-alt mr-1"></i>
                        Chain of Custody
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#transferModal">
                            <i class="fas fa-exchange-alt mr-1"></i> Transfer Custody
                        </button>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="timeline timeline-inverse p-3">
                        @if(is_array($evidence->chain_of_custody) && count($evidence->chain_of_custody) > 0)
                            @foreach($evidence->chain_of_custody as $index => $entry)
                                <div class="time-label">
                                    <span class="bg-primary">
                                        {{ \Carbon\Carbon::parse($entry['date'])->format('M d, Y') }}
                                    </span>
                                </div>
                                <div>
                                    <i class="fas fa-exchange-alt bg-primary"></i>
                                    <div class="timeline-item">
                                        <span class="time">
                                            <i class="far fa-clock"></i>
                                            {{ \Carbon\Carbon::parse($entry['date'])->format('H:i') }}
                                        </span>
                                        <h3 class="timeline-header">
                                            <strong>{{ App\Models\User::find($entry['to_officer_id'])->name ?? 'Unknown Officer' }}</strong>
                                            received from
                                            <strong>{{ App\Models\User::find($entry['from_officer_id'])->name ?? 'Unknown Officer' }}</strong>
                                        </h3>
                                        <div class="timeline-body">
                                            <strong>Reason:</strong> {{ $entry['reason'] ?? 'Not specified' }}<br>
                                            @if(isset($entry['notes']) && $entry['notes'])
                                                <strong>Notes:</strong> {{ $entry['notes'] }}
                                            @endif
                                        </div>
                                        <div class="timeline-footer">
                                            <small class="text-muted">
                                                Recorded by: {{ App\Models\User::find($entry['recorded_by'])->name ?? 'Unknown' }}
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            <div class="time-label">
                                <span class="bg-secondary">No Records</span>
                            </div>
                            <div>
                                <i class="fas fa-info bg-secondary"></i>
                                <div class="timeline-item">
                                    <h3 class="timeline-header">No custody transfers recorded</h3>
                                </div>
                            </div>
                        @endif
                        <div>
                            <i class="far fa-clock bg-gray"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <!-- Photos Card -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-images mr-1"></i>
                        Photos
                    </h3>
                </div>
                <div class="card-body">
                    @if(is_array($evidence->photos) && count($evidence->photos) > 0)
                        <div class="row">
                            @foreach($evidence->photos as $index => $photo)
                                @if(is_array($photo) && isset($photo['path']))
                                <div class="col-md-6 mb-3">
                                    <div class="position-relative">
                                        <img src="{{ asset('storage/' . $photo['path']) }}" class="img-fluid" alt="Evidence Photo">
                                        <div class="ribbon-wrapper ribbon-sm">
                                            <div class="ribbon bg-primary">
                                                Photo {{ $index + 1 }}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <small>{{ $photo['name'] ?? 'Evidence Photo' }}</small>
                                        <form action="{{ route('evidence.remove-photo', $evidence->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <input type="hidden" name="photo_index" value="{{ $index }}">
                                            <button type="submit" class="btn btn-danger btn-xs float-right" onclick="return confirm('Are you sure you want to remove this photo?')">
                                @endif
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <p class="text-muted">No photos attached to this evidence.</p>
                    @endif
                </div>
            </div>

            <!-- Documents Card -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-file-alt mr-1"></i>
                        Documents
                    </h3>
                </div>
                <div class="card-body">
                    @if(is_array($evidence->documents) && count($evidence->documents) > 0)
                        <ul class="list-group">
                            @foreach($evidence->documents as $index => $document)
                                @if(is_array($document) && isset($document['path']))
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <div>
                                        <a href="{{ asset('storage/' . $document['path']) }}" target="_blank">
                                            <i class="fas fa-file mr-2"></i>
                                            {{ $document['name'] ?? 'Evidence Document' }}
                                        </a>
                                        <br>
                                        <small class="text-muted">
                                            @if(isset($document['uploaded_at']))
                                            Uploaded: {{ \Carbon\Carbon::parse($document['uploaded_at'])->format('M d, Y H:i') }}
                                            @endif
                                        </small>
                                    </div>
                                    <form action="{{ route('evidence.remove-document', $evidence->id) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <input type="hidden" name="document_index" value="{{ $index }}">
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to remove this document?')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </li>
                                @endif
                            @endforeach
                        </ul>
                    @else
                        <p class="text-muted">No documents attached to this evidence.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Transfer Modal -->
    <div class="modal fade" id="transferModal" tabindex="-1" role="dialog" aria-labelledby="transferModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form action="{{ route('evidence.transfer', $evidence->id) }}" method="POST">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title" id="transferModalLabel">Transfer Custody</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="to_officer_id">Transfer To <span class="text-danger">*</span></label>
                            <select name="to_officer_id" id="to_officer_id" class="form-control" required>
                                <option value="">Select Officer</option>
                                @foreach($officers as $officer)
                                    <option value="{{ $officer->id }}">{{ $officer->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="reason">Reason for Transfer <span class="text-danger">*</span></label>
                            <select name="reason" id="reason" class="form-control" required>
                                <option value="Analysis">For Analysis</option>
                                <option value="Court">For Court Proceedings</option>
                                <option value="Storage">For Storage</option>
                                <option value="Investigation">For Investigation</option>
                                <option value="Other">Other</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="notes">Notes</label>
                            <textarea name="notes" id="notes" rows="3" class="form-control"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Transfer Custody</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
    <style>
        .timeline {
            margin: 0;
            padding: 0;
            position: relative;
        }
        .timeline-item {
            margin-right: 0;
        }
    </style>
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Initialize any plugins or JS functionality here
        });
    </script>
@stop
