@extends('adminlte::page')

@section('title', 'Batch Assign Officers')

@section('content_header')
    <h1>Batch Assign Officers to Station</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('officers.process-batch-assignment') }}" method="POST">
                @csrf
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="station_id">Select Station <span class="text-danger">*</span></label>
                            <select class="form-control @error('station_id') is-invalid @enderror" id="station_id" name="station_id" required>
                                <option value="">-- Select Station --</option>
                                @foreach($stations as $station)
                                    <option value="{{ $station->id }}" {{ old('station_id') == $station->id ? 'selected' : '' }}>
                                        {{ $station->name }} ({{ $station->code }})
                                    </option>
                                @endforeach
                            </select>
                            @error('station_id')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="card card-outline card-primary">
                            <div class="card-header">
                                <h3 class="card-title">Select Officers to Assign</h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" id="select-all">
                                        <i class="fas fa-check-square"></i> Select All
                                    </button>
                                    <button type="button" class="btn btn-tool" id="deselect-all">
                                        <i class="far fa-square"></i> Deselect All
                                    </button>
                                </div>
                            </div>
                            <div class="card-body">
                                @if($officers->count() > 0)
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th style="width: 10px">#</th>
                                                    <th>Name</th>
                                                    <th>Rank</th>
                                                    <th>Badge Number</th>
                                                    <th>Current Station</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($officers as $officer)
                                                    <tr>
                                                        <td>
                                                            <div class="icheck-primary">
                                                                <input type="checkbox" name="officer_ids[]" value="{{ $officer->id }}" id="officer{{ $officer->id }}">
                                                                <label for="officer{{ $officer->id }}"></label>
                                                            </div>
                                                        </td>
                                                        <td>{{ $officer->name }}</td>
                                                        <td>{{ $officer->rank ?? 'N/A' }}</td>
                                                        <td>{{ $officer->badge_number ?? 'N/A' }}</td>
                                                        <td>
                                                            @if($officer->station)
                                                                {{ $officer->station->name }}
                                                            @else
                                                                <span class="text-muted">Not Assigned</span>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                @else
                                    <div class="alert alert-info">
                                        No officers available for assignment.
                                    </div>
                                @endif
                                
                                @error('officer_ids')
                                    <div class="text-danger mt-2">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-12">
                        <a href="{{ route('officers.index') }}" class="btn btn-secondary">Cancel</a>
                        <button type="submit" class="btn btn-primary float-right" {{ $officers->count() == 0 ? 'disabled' : '' }}>
                            Assign Officers
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Select all checkboxes
            $('#select-all').click(function() {
                $('input[name="officer_ids[]"]').prop('checked', true);
            });
            
            // Deselect all checkboxes
            $('#deselect-all').click(function() {
                $('input[name="officer_ids[]"]').prop('checked', false);
            });
        });
    </script>
@stop
