@extends('adminlte::page')

@section('title', 'Edit Officer')

@section('content_header')
    <h1>Edit Officer: {{ $officer->name }}</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('officers.update', $officer) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name">Full Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $officer->name) }}" required>
                            @error('name')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="email">Email Address <span class="text-danger">*</span></label>
                            <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email', $officer->email) }}" required>
                            @error('email')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="password">Password</label>
                            <input type="password" class="form-control @error('password') is-invalid @enderror" id="password" name="password">
                            <small class="form-text text-muted">Leave blank to keep current password. Minimum 8 characters if changing.</small>
                            @error('password')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="rank">Rank</label>
                            <select class="form-control @error('rank') is-invalid @enderror" id="rank" name="rank">
                                <option value="">-- Select Rank --</option>
                                <option value="Constable" {{ old('rank', $officer->rank) == 'Constable' ? 'selected' : '' }}>Constable</option>
                                <option value="Corporal" {{ old('rank', $officer->rank) == 'Corporal' ? 'selected' : '' }}>Corporal</option>
                                <option value="Sergeant" {{ old('rank', $officer->rank) == 'Sergeant' ? 'selected' : '' }}>Sergeant</option>
                                <option value="Inspector" {{ old('rank', $officer->rank) == 'Inspector' ? 'selected' : '' }}>Inspector</option>
                                <option value="Chief Inspector" {{ old('rank', $officer->rank) == 'Chief Inspector' ? 'selected' : '' }}>Chief Inspector</option>
                                <option value="Assistant Superintendent" {{ old('rank', $officer->rank) == 'Assistant Superintendent' ? 'selected' : '' }}>Assistant Superintendent</option>
                                <option value="Deputy Superintendent" {{ old('rank', $officer->rank) == 'Deputy Superintendent' ? 'selected' : '' }}>Deputy Superintendent</option>
                                <option value="Superintendent" {{ old('rank', $officer->rank) == 'Superintendent' ? 'selected' : '' }}>Superintendent</option>
                                <option value="Commissioner" {{ old('rank', $officer->rank) == 'Commissioner' ? 'selected' : '' }}>Commissioner</option>
                            </select>
                            @error('rank')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="profile_picture">Profile Picture</label>
                            @if($officer->profile_picture)
                                <div class="mb-2">
                                    <img src="{{ asset('storage/profile_pictures/' . $officer->profile_picture) }}" 
                                         alt="{{ $officer->name }}" 
                                         class="img-circle elevation-2" 
                                         style="width: 100px; height: 100px; object-fit: cover;">
                                </div>
                            @endif
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('profile_picture') is-invalid @enderror" id="profile_picture" name="profile_picture" accept="image/*">
                                    <label class="custom-file-label" for="profile_picture">{{ $officer->profile_picture ? 'Change picture' : 'Choose file' }}</label>
                                </div>
                            </div>
                            <small class="form-text text-muted">Upload a profile picture (JPG, PNG, GIF)</small>
                            @error('profile_picture')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="badge_number">Badge Number</label>
                            <input type="text" class="form-control @error('badge_number') is-invalid @enderror" id="badge_number" name="badge_number" value="{{ old('badge_number', $officer->badge_number) }}">
                            <small class="form-text text-muted">Must be unique</small>
                            @error('badge_number')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="station_id">Assigned Station</label>
                            <select class="form-control @error('station_id') is-invalid @enderror" id="station_id" name="station_id">
                                <option value="">-- Select Station --</option>
                                @foreach($stations as $station)
                                    <option value="{{ $station->id }}" {{ old('station_id', $officer->station_id) == $station->id ? 'selected' : '' }}>
                                        {{ $station->name }} ({{ $station->code }})
                                    </option>
                                @endforeach
                            </select>
                            @error('station_id')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-12">
                        <a href="{{ route('officers.index') }}" class="btn btn-secondary">Cancel</a>
                        <button type="submit" class="btn btn-primary float-right">Update Officer</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        console.log('Edit Officer page loaded!');
        
        // Display selected filename in the custom file input
        $(document).ready(function() {
            bsCustomFileInput.init();
        });
    </script>
@stop
