@extends('adminlte::page')

@section('title', 'Officers Management')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Officers Management</h1>
        <div>
            <a href="{{ route('officers.assign-batch') }}" class="btn btn-info mr-2">
                <i class="fas fa-users-cog"></i> Batch Assign
            </a>
            <a href="{{ route('officers.create') }}" class="btn btn-primary">
                <i class="fas fa-user-plus"></i> Add New Officer
            </a>
        </div>
    </div>
@stop

@section('content')
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <table class="table table-bordered table-striped" id="officers-table">
                <thead>
                    <tr>
                        <th>Photo</th>
                        <th>Name</th>
                        <th>Rank</th>
                        <th>Badge Number</th>
                        <th>Station</th>
                        <th>Email</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($officers as $officer)
                        <tr>
                            <td class="text-center">
                                @if($officer->profile_picture)
                                    <img src="{{ asset('storage/profile_pictures/' . $officer->profile_picture) }}" 
                                         alt="{{ $officer->name }}" 
                                         class="img-circle elevation-2" 
                                         style="width: 50px; height: 50px; object-fit: cover;">
                                @else
                                    <img src="{{ asset('img/user-profile.png') }}" 
                                         alt="{{ $officer->name }}" 
                                         class="img-circle elevation-2" 
                                         style="width: 50px; height: 50px; object-fit: cover;">
                                @endif
                            </td>
                            <td>{{ $officer->name }}</td>
                            <td>{{ $officer->rank ?? 'N/A' }}</td>
                            <td>{{ $officer->badge_number ?? 'N/A' }}</td>
                            <td>
                                @if ($officer->station)
                                    <a href="{{ route('stations.show', $officer->station) }}">
                                        {{ $officer->station->name }}
                                    </a>
                                @else
                                    <span class="text-muted">Not Assigned</span>
                                @endif
                            </td>
                            <td>{{ $officer->email }}</td>
                            <td>
                                <div class="btn-group">
                                    <a href="{{ route('officers.show', $officer) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('officers.edit', $officer) }}" class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $officer->id }}">
                                        <i class="fas fa-user-minus"></i>
                                    </button>
                                </div>

                                <!-- Delete Modal -->
                                <div class="modal fade" id="deleteModal{{ $officer->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="deleteModalLabel">Remove Officer</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                Are you sure you want to remove <strong>{{ $officer->name }}</strong> from the officers list?
                                                <p class="text-muted mt-2">Note: This will not delete the user account, but will remove their officer status and station assignment.</p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                <form action="{{ route('officers.destroy', $officer) }}" method="POST" style="display: inline-block;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger">Remove Officer</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center">No officers found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="d-flex justify-content-center">
        {{ $officers->links() }}
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            $('#officers-table').DataTable({
                "paging": false,
                "lengthChange": false,
                "searching": true,
                "ordering": true,
                "info": false,
                "autoWidth": false,
                "responsive": true,
            });
        });
    </script>
@stop
