@extends('adminlte::page')

@section('title', 'Officer Details')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Officer Details</h1>
        <div>
            <a href="{{ route('officers.edit', $officer) }}" class="btn btn-warning">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="{{ route('officers.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to List
            </a>
        </div>
    </div>
@stop

@section('content')
    <div class="row">
        <div class="col-md-4">
            <div class="card card-primary card-outline">
                <div class="card-body box-profile">
                    <div class="text-center">
                        <img class="profile-user-img img-fluid img-circle" 
                             src="{{ $officer->profile_picture ? asset('storage/profile_pictures/' . $officer->profile_picture) : asset('img/user-profile.png') }}" 
                             alt="Officer profile picture">
                    </div>

                    <h3 class="profile-username text-center">{{ $officer->name }}</h3>

                    <p class="text-muted text-center">
                        {{ $officer->rank ?? 'No Rank' }}
                        @if ($officer->badge_number)
                            <span class="badge badge-info">{{ $officer->badge_number }}</span>
                        @endif
                    </p>

                    <ul class="list-group list-group-unbordered mb-3">
                        <li class="list-group-item">
                            <b>Email</b> <a class="float-right">{{ $officer->email }}</a>
                        </li>
                        <li class="list-group-item">
                            <b>Station</b> 
                            <span class="float-right">
                                @if ($officer->station)
                                    <a href="{{ route('stations.show', $officer->station) }}">
                                        {{ $officer->station->name }}
                                    </a>
                                @else
                                    <span class="text-muted">Not Assigned</span>
                                @endif
                            </span>
                        </li>
                        <li class="list-group-item">
                            <b>Joined</b> <span class="float-right">{{ $officer->created_at->format('d M Y') }}</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        
        <div class="col-md-8">
            <div class="card">
                <div class="card-header p-2">
                    <ul class="nav nav-pills">
                        <li class="nav-item"><a class="nav-link active" href="#activity" data-toggle="tab">Activity</a></li>
                        <li class="nav-item"><a class="nav-link" href="#cases" data-toggle="tab">Cases</a></li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content">
                        <div class="active tab-pane" id="activity">
                            <div class="timeline timeline-inverse">
                                <!-- Timeline will be implemented when activity logging is added -->
                                <div>
                                    <i class="fas fa-info bg-info"></i>
                                    <div class="timeline-item">
                                        <h3 class="timeline-header">No activity recorded yet</h3>
                                        <div class="timeline-body">
                                            Officer activity tracking will be implemented in a future update.
                                        </div>
                                    </div>
                                </div>
                                <div>
                                    <i class="far fa-clock bg-gray"></i>
                                </div>
                            </div>
                        </div>
                        
                        <div class="tab-pane" id="cases">
                            @if($cases->count() > 0)
                                <div class="table-responsive">
                                    <table class="table table-hover text-nowrap">
                                        <thead>
                                            <tr>
                                                <th>Case Number</th>
                                                <th>Title</th>
                                                <th>Status</th>
                                                <th>Priority</th>
                                                <th>Role</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($cases as $case)
                                                <tr>
                                                    <td>{{ $case->case_number }}</td>
                                                    <td>{{ $case->title }}</td>
                                                    <td>
                                                        <span class="badge {{ $case->status_badge_class }}">
                                                            {{ $case->status_label }}
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="badge {{ $case->priority_badge_class }}">
                                                            {{ $case->priority_label }}
                                                        </span>
                                                    </td>
                                                    <td>
                                                        @if($case->lead_investigator_id == $officer->id)
                                                            <span class="badge badge-primary">Lead Investigator</span>
                                                        @elseif($case->reporting_officer_id == $officer->id)
                                                            <span class="badge badge-info">Reporting Officer</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <a href="{{ route('cases.show', $case->id) }}" class="btn btn-xs btn-info">
                                                            <i class="fas fa-eye"></i> View
                                                        </a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="alert alert-info">
                                    <h5><i class="icon fas fa-info"></i> No Cases</h5>
                                    This officer has not been assigned to any cases yet.
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        console.log('Officer Details page loaded!');
    </script>
@stop
