@extends('adminlte::page')

@section('title', 'Officer Performance')

@section('content_header')
    <h1><i class="fas fa-chart-line mr-2"></i>Officer Performance</h1>
@stop

@section('content')
    <div class="row mb-3">
        <div class="col-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-filter mr-1"></i>
                        Filter Options
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('reports.performance') }}" method="GET" class="form-horizontal">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Date Range:</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">
                                                <i class="far fa-calendar-alt"></i>
                                            </span>
                                        </div>
                                        <input type="date" class="form-control" name="start_date" value="{{ $startDate->format('Y-m-d') }}">
                                        <div class="input-group-prepend input-group-append">
                                            <span class="input-group-text">to</span>
                                        </div>
                                        <input type="date" class="form-control" name="end_date" value="{{ $endDate->format('Y-m-d') }}">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Police Station:</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">
                                                <i class="fas fa-building"></i>
                                            </span>
                                        </div>
                                        <select class="form-control select2" name="station_id">
                                            <option value="">All Stations</option>
                                            @foreach($stations as $station)
                                                <option value="{{ $station->id }}" {{ $stationId == $station->id ? 'selected' : '' }}>
                                                    {{ $station->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 d-flex align-items-end">
                                <div class="form-group mb-0 w-100">
                                    <button type="submit" class="btn btn-primary btn-block">
                                        <i class="fas fa-filter mr-1"></i> Apply Filters
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-trophy mr-1"></i>
                        Top Performing Officers
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body p-0">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th style="width: 10px">#</th>
                                <th>Officer</th>
                                <th>Station</th>
                                <th class="text-center">Lead Cases</th>
                                <th class="text-center">Reporting Cases</th>
                                <th class="text-center">Statements</th>
                                <th class="text-center">Evidence</th>
                                <th class="text-center">Total Activity</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($topPerformers as $index => $officer)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $officer->name }}</td>
                                    <td>{{ $officer->station->name ?? 'N/A' }}</td>
                                    <td class="text-center">{{ $officer->lead_cases_count }}</td>
                                    <td class="text-center">{{ $officer->reporting_cases_count }}</td>
                                    <td class="text-center">{{ $officer->statements_count }}</td>
                                    <td class="text-center">{{ $officer->evidence_count }}</td>
                                    <td class="text-center">
                                        <span class="badge bg-primary">{{ $officer->total_activity }}</span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-chart-pie mr-1"></i>
                        Activity Distribution
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="activityDistributionChart" style="min-height: 300px; height: 300px; max-height: 300px; max-width: 100%;"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-check-circle mr-1"></i>
                        Case Resolution Rates
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body p-0">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Officer</th>
                                <th class="text-center">Total Cases</th>
                                <th class="text-center">Solved</th>
                                <th class="text-right">Resolution Rate</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($officerResolutionRates as $officerId => $data)
                                <tr>
                                    <td>{{ $data['name'] }}</td>
                                    <td class="text-center">{{ $data['total'] }}</td>
                                    <td class="text-center">{{ $data['solved'] }}</td>
                                    <td class="text-right">
                                        {{ $data['rate'] }}%
                                        <div class="progress progress-xs">
                                            <div class="progress-bar bg-success" style="width: {{ $data['rate'] }}%"></div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-clock mr-1"></i>
                        Average Response Time
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="responseTimeChart" style="min-height: 300px; height: 300px; max-height: 300px; max-width: 100%;"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-users mr-1"></i>
                        All Officers Performance
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body p-0">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>Officer</th>
                                <th>Station</th>
                                <th class="text-center">Lead Cases</th>
                                <th class="text-center">Reporting Cases</th>
                                <th class="text-center">Statements</th>
                                <th class="text-center">Evidence</th>
                                <th class="text-center">Total Activity</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($officers as $officer)
                                <tr>
                                    <td>{{ $officer->name }}</td>
                                    <td>{{ $officer->station->name ?? 'N/A' }}</td>
                                    <td class="text-center">{{ $officer->lead_cases_count }}</td>
                                    <td class="text-center">{{ $officer->reporting_cases_count }}</td>
                                    <td class="text-center">{{ $officer->statements_count }}</td>
                                    <td class="text-center">{{ $officer->evidence_count }}</td>
                                    <td class="text-center">
                                        <span class="badge {{ $officer->total_activity > 10 ? 'bg-success' : ($officer->total_activity > 5 ? 'bg-primary' : 'bg-secondary') }}">
                                            {{ $officer->total_activity }}
                                        </span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@x.x.x/dist/select2-bootstrap4.min.css">
    <style>
        .select2-container--bootstrap4 .select2-selection--single {
            height: calc(2.25rem + 2px) !important;
        }
    </style>
@stop

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.7.1/dist/chart.min.js"></script>
    <script>
        $(function () {
            $('.select2').select2({
                theme: 'bootstrap4',
            });
            
            // Activity Distribution Chart
            const ctxActivity = document.getElementById('activityDistributionChart').getContext('2d');
            
            // Calculate totals for each activity type
            let totalLeadCases = 0;
            let totalReportingCases = 0;
            let totalStatements = 0;
            let totalEvidence = 0;
            
            @foreach($officers as $officer)
                totalLeadCases += {{ $officer->lead_cases_count }};
                totalReportingCases += {{ $officer->reporting_cases_count }};
                totalStatements += {{ $officer->statements_count }};
                totalEvidence += {{ $officer->evidence_count }};
            @endforeach
            
            const activityDistributionChart = new Chart(ctxActivity, {
                type: 'doughnut',
                data: {
                    labels: ['Lead Cases', 'Reporting Cases', 'Statements', 'Evidence'],
                    datasets: [{
                        data: [totalLeadCases, totalReportingCases, totalStatements, totalEvidence],
                        backgroundColor: [
                            '#007bff', // primary
                            '#28a745', // success
                            '#ffc107', // warning
                            '#17a2b8'  // info
                        ],
                        hoverOffset: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false
                }
            });
            
            // Response Time Chart
            const ctxResponseTime = document.getElementById('responseTimeChart').getContext('2d');
            const responseTimeLabels = [];
            const responseTimeData = [];
            
            @foreach($officerResponseTimes as $officerId => $data)
                responseTimeLabels.push('{{ $data['name'] }}');
                responseTimeData.push({{ $data['days'] }});
            @endforeach
            
            const responseTimeChart = new Chart(ctxResponseTime, {
                type: 'bar',
                data: {
                    labels: responseTimeLabels,
                    datasets: [{
                        label: 'Average Response Time (Days)',
                        data: responseTimeData,
                        backgroundColor: 'rgba(60, 141, 188, 0.8)',
                        borderColor: 'rgba(60, 141, 188, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: 'Days'
                            }
                        }
                    },
                    plugins: {
                        title: {
                            display: true,
                            text: 'Average Days to First Update'
                        }
                    }
                }
            });
        });
    </script>
@stop
