@extends('adminlte::page')

@section('title', 'Station Reports')

@section('content_header')
    <h1><i class="fas fa-file-alt mr-2"></i>Station Reports</h1>
@stop

@section('content')
    <div class="row mb-3">
        <div class="col-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-filter mr-1"></i>
                        Filter Options
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('reports.stations') }}" method="GET" class="form-horizontal">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label>Date Range:</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">
                                                <i class="far fa-calendar-alt"></i>
                                            </span>
                                        </div>
                                        <input type="date" class="form-control" name="start_date" value="{{ $startDate->format('Y-m-d') }}">
                                        <div class="input-group-prepend input-group-append">
                                            <span class="input-group-text">to</span>
                                        </div>
                                        <input type="date" class="form-control" name="end_date" value="{{ $endDate->format('Y-m-d') }}">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 d-flex align-items-end">
                                <div class="form-group mb-0 w-100">
                                    <button type="submit" class="btn btn-primary btn-block">
                                        <i class="fas fa-filter mr-1"></i> Apply Filters
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-building mr-1"></i>
                        Station Performance Overview
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>Station</th>
                                    <th class="text-center">Officers</th>
                                    <th class="text-center">Total Cases</th>
                                    <th class="text-center">Open Cases</th>
                                    <th class="text-center">Closed Cases</th>
                                    <th class="text-center">Resolution Rate</th>
                                    <th class="text-center">Bail Check-ins</th>
                                    <th class="text-center">Compliance Rate</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($stations as $station)
                                    <tr>
                                        <td>
                                            <strong>{{ $station->name }}</strong><br>
                                            <small class="text-muted">{{ $station->location }}</small>
                                        </td>
                                        <td class="text-center">
                                            {{ $officersByStation[$station->id] ?? 0 }}
                                        </td>
                                        <td class="text-center">{{ $station->total_cases }}</td>
                                        <td class="text-center">{{ $station->open_cases }}</td>
                                        <td class="text-center">{{ $station->closed_cases }}</td>
                                        <td class="text-center">
                                            <div class="d-flex align-items-center justify-content-center">
                                                <span class="mr-2">{{ $station->resolution_rate }}%</span>
                                                <div class="progress progress-xs flex-grow-1" style="max-width: 100px;">
                                                    <div class="progress-bar bg-success" style="width: {{ $station->resolution_rate }}%"></div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center">{{ $station->total_checkins }}</td>
                                        <td class="text-center">
                                            <div class="d-flex align-items-center justify-content-center">
                                                <span class="mr-2">{{ $station->compliance_rate }}%</span>
                                                <div class="progress progress-xs flex-grow-1" style="max-width: 100px;">
                                                    <div class="progress-bar {{ $station->compliance_rate >= 90 ? 'bg-success' : ($station->compliance_rate >= 75 ? 'bg-warning' : 'bg-danger') }}" 
                                                        style="width: {{ $station->compliance_rate }}%"></div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-chart-bar mr-1"></i>
                        Case Resolution Rate by Station
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="resolutionRateChart" style="min-height: 300px; height: 300px; max-height: 300px; max-width: 100%;"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-chart-bar mr-1"></i>
                        Bail Compliance Rate by Station
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="complianceRateChart" style="min-height: 300px; height: 300px; max-height: 300px; max-width: 100%;"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-chart-line mr-1"></i>
                        Monthly Case Trends by Top Stations
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="monthlyTrendsChart" style="min-height: 400px; height: 400px; max-height: 400px; max-width: 100%;"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        @foreach($stations->take(3) as $station)
            <div class="col-md-4">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-chart-pie mr-1"></i>
                            {{ $station->name }} - Top Crime Types
                        </h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="crimeTypeChart{{ $station->id }}" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@stop

@section('css')
    <style>
        .progress {
            height: 5px;
        }
    </style>
@stop

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.7.1/dist/chart.min.js"></script>
    <script>
        $(function () {
            // Resolution Rate Chart
            const ctxResolution = document.getElementById('resolutionRateChart').getContext('2d');
            const resolutionLabels = [];
            const resolutionData = [];
            
            @foreach($stations->take(10) as $station)
                resolutionLabels.push('{{ $station->name }}');
                resolutionData.push({{ $station->resolution_rate }});
            @endforeach
            
            const resolutionRateChart = new Chart(ctxResolution, {
                type: 'bar',
                data: {
                    labels: resolutionLabels,
                    datasets: [{
                        label: 'Resolution Rate (%)',
                        data: resolutionData,
                        backgroundColor: 'rgba(40, 167, 69, 0.8)',
                        borderColor: 'rgba(40, 167, 69, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            max: 100,
                            title: {
                                display: true,
                                text: 'Percentage (%)'
                            }
                        }
                    }
                }
            });
            
            // Compliance Rate Chart
            const ctxCompliance = document.getElementById('complianceRateChart').getContext('2d');
            const complianceLabels = [];
            const complianceData = [];
            const complianceColors = [];
            
            @foreach($stations->take(10) as $station)
                complianceLabels.push('{{ $station->name }}');
                complianceData.push({{ $station->compliance_rate }});
                
                @if($station->compliance_rate >= 90)
                    complianceColors.push('rgba(40, 167, 69, 0.8)'); // success/green
                @elseif($station->compliance_rate >= 75)
                    complianceColors.push('rgba(255, 193, 7, 0.8)'); // warning/yellow
                @else
                    complianceColors.push('rgba(220, 53, 69, 0.8)'); // danger/red
                @endif
            @endforeach
            
            const complianceRateChart = new Chart(ctxCompliance, {
                type: 'bar',
                data: {
                    labels: complianceLabels,
                    datasets: [{
                        label: 'Bail Compliance Rate (%)',
                        data: complianceData,
                        backgroundColor: complianceColors,
                        borderColor: complianceColors.map(color => color.replace('0.8', '1')),
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            max: 100,
                            title: {
                                display: true,
                                text: 'Percentage (%)'
                            }
                        }
                    }
                }
            });
            
            // Monthly Trends Chart
            const ctxMonthly = document.getElementById('monthlyTrendsChart').getContext('2d');
            const monthlyTrendsDatasets = [];
            
            // Define colors for each station line
            const lineColors = [
                'rgba(0, 123, 255, 1)',    // primary/blue
                'rgba(40, 167, 69, 1)',    // success/green
                'rgba(255, 193, 7, 1)',    // warning/yellow
                'rgba(220, 53, 69, 1)',    // danger/red
                'rgba(23, 162, 184, 1)'    // info/teal
            ];
            
            let colorIndex = 0;
            @foreach($monthlyTrendsByStation as $stationId => $data)
                monthlyTrendsDatasets.push({
                    label: '{{ $data['name'] }}',
                    data: {!! json_encode($data['data']) !!},
                    borderColor: lineColors[colorIndex],
                    backgroundColor: lineColors[colorIndex].replace('1)', '0.1)'),
                    borderWidth: 2,
                    fill: false,
                    tension: 0.1
                });
                colorIndex = (colorIndex + 1) % lineColors.length;
            @endforeach
            
            // Use the labels from the first station (they should all have the same date range)
            const monthlyLabels = @json($monthlyTrendsByStation[array_key_first($monthlyTrendsByStation)]['labels'] ?? []);
            
            const monthlyTrendsChart = new Chart(ctxMonthly, {
                type: 'line',
                data: {
                    labels: monthlyLabels,
                    datasets: monthlyTrendsDatasets
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                precision: 0
                            },
                            title: {
                                display: true,
                                text: 'Number of Cases'
                            }
                        }
                    }
                }
            });
            
            // Crime Type Charts for Top 3 Stations
            @foreach($stations->take(3) as $station)
                @if(isset($caseTypesByStation[$station->id]) && count($caseTypesByStation[$station->id]) > 0)
                    const ctxCrimeType{{ $station->id }} = document.getElementById('crimeTypeChart{{ $station->id }}').getContext('2d');
                    const crimeTypeLabels{{ $station->id }} = [];
                    const crimeTypeData{{ $station->id }} = [];
                    
                    @foreach($caseTypesByStation[$station->id] as $crimeType)
                        crimeTypeLabels{{ $station->id }}.push('{{ ucfirst(str_replace('_', ' ', $crimeType->crime_type)) }}');
                        crimeTypeData{{ $station->id }}.push({{ $crimeType->total }});
                    @endforeach
                    
                    const crimeTypeChart{{ $station->id }} = new Chart(ctxCrimeType{{ $station->id }}, {
                        type: 'pie',
                        data: {
                            labels: crimeTypeLabels{{ $station->id }},
                            datasets: [{
                                data: crimeTypeData{{ $station->id }},
                                backgroundColor: [
                                    '#f56954', '#00a65a', '#f39c12', '#00c0ef', '#3c8dbc', '#d2d6de'
                                ],
                                hoverOffset: 4
                            }]
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false
                        }
                    });
                @endif
            @endforeach
        });
    </script>
@stop
