@extends('adminlte::page')

@section('title', 'Crime Statistics')

@section('content_header')
    <h1><i class="fas fa-chart-bar mr-2"></i>Crime Statistics</h1>
@stop

@section('content')
    <div class="row mb-3">
        <div class="col-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-filter mr-1"></i>
                        Filter Options
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('reports.statistics') }}" method="GET" class="form-horizontal">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Date Range:</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">
                                                <i class="far fa-calendar-alt"></i>
                                            </span>
                                        </div>
                                        <input type="date" class="form-control" name="start_date" value="{{ $startDate->format('Y-m-d') }}">
                                        <div class="input-group-prepend input-group-append">
                                            <span class="input-group-text">to</span>
                                        </div>
                                        <input type="date" class="form-control" name="end_date" value="{{ $endDate->format('Y-m-d') }}">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Police Station:</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">
                                                <i class="fas fa-building"></i>
                                            </span>
                                        </div>
                                        <select class="form-control select2" name="station_id">
                                            <option value="">All Stations</option>
                                            @foreach($stations as $station)
                                                <option value="{{ $station->id }}" {{ $stationId == $station->id ? 'selected' : '' }}>
                                                    {{ $station->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 d-flex align-items-end">
                                <div class="form-group mb-0 w-100">
                                    <button type="submit" class="btn btn-primary btn-block">
                                        <i class="fas fa-filter mr-1"></i> Apply Filters
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3>{{ $totalCases }}</h3>
                    <p>Total Cases</p>
                </div>
                <div class="icon">
                    <i class="fas fa-folder"></i>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3>{{ $solvedCases }}</h3>
                    <p>Solved Cases</p>
                </div>
                <div class="icon">
                    <i class="fas fa-check-circle"></i>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3>{{ $solvedRate }}%</h3>
                    <p>Case Resolution Rate</p>
                </div>
                <div class="icon">
                    <i class="fas fa-percentage"></i>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-danger">
                <div class="inner">
                    <h3>{{ $totalCases - $solvedCases }}</h3>
                    <p>Open Cases</p>
                </div>
                <div class="icon">
                    <i class="fas fa-exclamation-circle"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-chart-line mr-1"></i>
                        Case Trends Over Time
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="caseTrendsChart" style="min-height: 300px; height: 300px; max-height: 300px; max-width: 100%;"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-chart-pie mr-1"></i>
                        Cases by Status
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="caseStatusChart" style="min-height: 300px; height: 300px; max-height: 300px; max-width: 100%;"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-chart-pie mr-1"></i>
                        Cases by Crime Type
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="crimeTypeChart" style="min-height: 300px; height: 300px; max-height: 300px; max-width: 100%;"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-chart-pie mr-1"></i>
                        Cases by Priority
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="priorityChart" style="min-height: 300px; height: 300px; max-height: 300px; max-width: 100%;"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-map-marker-alt mr-1"></i>
                        Crime Hotspots
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body p-0">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Location</th>
                                <th class="text-center">Cases</th>
                                <th class="text-right">Percentage</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($crimeHotspots as $hotspot)
                                <tr>
                                    <td>{{ $hotspot->location }}</td>
                                    <td class="text-center">{{ $hotspot->total }}</td>
                                    <td class="text-right">
                                        {{ number_format(($hotspot->total / $totalCases) * 100, 1) }}%
                                        <div class="progress progress-xs">
                                            <div class="progress-bar bg-danger" style="width: {{ ($hotspot->total / $totalCases) * 100 }}%"></div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-users mr-1"></i>
                        Victim & Suspect Demographics
                    </h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h5 class="text-center">Victim Types</h5>
                            <canvas id="victimChart" style="min-height: 200px; height: 200px; max-height: 200px; max-width: 100%;"></canvas>
                        </div>
                        <div class="col-md-6">
                            <h5 class="text-center">Suspect Gender</h5>
                            <canvas id="suspectChart" style="min-height: 200px; height: 200px; max-height: 200px; max-width: 100%;"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@x.x.x/dist/select2-bootstrap4.min.css">
    <style>
        .select2-container--bootstrap4 .select2-selection--single {
            height: calc(2.25rem + 2px) !important;
        }
    </style>
@stop

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.7.1/dist/chart.min.js"></script>
    <script>
        $(function () {
            $('.select2').select2({
                theme: 'bootstrap4',
            });
            
            // Case trends chart
            const ctxTrends = document.getElementById('caseTrendsChart').getContext('2d');
            const caseTrendsChart = new Chart(ctxTrends, {
                type: 'line',
                data: {
                    labels: {!! json_encode($monthLabels) !!},
                    datasets: [{
                        label: 'Number of Cases',
                        data: {!! json_encode($monthData) !!},
                        borderColor: '#007bff',
                        backgroundColor: 'rgba(0, 123, 255, 0.1)',
                        borderWidth: 2,
                        fill: true,
                        tension: 0.1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                precision: 0
                            }
                        }
                    }
                }
            });
            
            // Case status chart
            const ctxStatus = document.getElementById('caseStatusChart').getContext('2d');
            const statusLabels = [];
            const statusData = [];
            const statusColors = [];
            
            @foreach($casesByStatus as $status)
                statusLabels.push('{{ ucfirst(str_replace('_', ' ', $status->status)) }}');
                statusData.push({{ $status->total }});
                @switch($status->status)
                    @case('open')
                        statusColors.push('#17a2b8'); // info
                        @break
                    @case('under_investigation')
                        statusColors.push('#ffc107'); // warning
                        @break
                    @case('pending_review')
                        statusColors.push('#6c757d'); // secondary
                        @break
                    @case('closed')
                        statusColors.push('#28a745'); // success
                        @break
                    @default
                        statusColors.push('#6c757d'); // secondary
                @endswitch
            @endforeach
            
            const caseStatusChart = new Chart(ctxStatus, {
                type: 'doughnut',
                data: {
                    labels: statusLabels,
                    datasets: [{
                        data: statusData,
                        backgroundColor: statusColors,
                        hoverOffset: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false
                }
            });
            
            // Crime type chart
            const ctxCrimeType = document.getElementById('crimeTypeChart').getContext('2d');
            const crimeTypeLabels = [];
            const crimeTypeData = [];
            
            @foreach($casesByCrimeType as $crimeType)
                crimeTypeLabels.push('{{ ucfirst(str_replace('_', ' ', $crimeType->crime_type)) }}');
                crimeTypeData.push({{ $crimeType->total }});
            @endforeach
            
            const crimeTypeChart = new Chart(ctxCrimeType, {
                type: 'bar',
                data: {
                    labels: crimeTypeLabels,
                    datasets: [{
                        label: 'Number of Cases',
                        data: crimeTypeData,
                        backgroundColor: 'rgba(60, 141, 188, 0.8)',
                        borderColor: 'rgba(60, 141, 188, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                precision: 0
                            }
                        }
                    }
                }
            });
            
            // Priority chart
            const ctxPriority = document.getElementById('priorityChart').getContext('2d');
            const priorityLabels = [];
            const priorityData = [];
            const priorityColors = [];
            
            @foreach($casesByPriority as $priority)
                priorityLabels.push('{{ ucfirst($priority->priority) }}');
                priorityData.push({{ $priority->total }});
                @switch($priority->priority)
                    @case('low')
                        priorityColors.push('#28a745'); // success/green
                        @break
                    @case('medium')
                        priorityColors.push('#ffc107'); // warning/yellow
                        @break
                    @case('high')
                        priorityColors.push('#dc3545'); // danger/red
                        @break
                    @default
                        priorityColors.push('#6c757d'); // secondary/gray
                @endswitch
            @endforeach
            
            const priorityChart = new Chart(ctxPriority, {
                type: 'pie',
                data: {
                    labels: priorityLabels,
                    datasets: [{
                        data: priorityData,
                        backgroundColor: priorityColors,
                        hoverOffset: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false
                }
            });
            
            // Victim chart
            const ctxVictim = document.getElementById('victimChart').getContext('2d');
            const victimLabels = [];
            const victimData = [];
            
            @foreach($victimDemographics as $victim)
                victimLabels.push('{{ ucfirst($victim->victim_type) }}');
                victimData.push({{ $victim->total }});
            @endforeach
            
            const victimChart = new Chart(ctxVictim, {
                type: 'pie',
                data: {
                    labels: victimLabels,
                    datasets: [{
                        data: victimData,
                        backgroundColor: [
                            '#f56954', '#00a65a', '#f39c12', '#00c0ef', '#3c8dbc', '#d2d6de'
                        ],
                        hoverOffset: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false
                }
            });
            
            // Suspect chart
            const ctxSuspect = document.getElementById('suspectChart').getContext('2d');
            const suspectLabels = [];
            const suspectData = [];
            
            @foreach($suspectDemographics as $suspect)
                suspectLabels.push('{{ $suspect->gender }}');
                suspectData.push({{ $suspect->total }});
            @endforeach
            
            const suspectChart = new Chart(ctxSuspect, {
                type: 'pie',
                data: {
                    labels: suspectLabels,
                    datasets: [{
                        data: suspectData,
                        backgroundColor: [
                            '#007bff', '#fd7e14', '#6c757d'
                        ],
                        hoverOffset: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false
                }
            });
        });
    </script>
@stop
