@extends('adminlte::page')

@section('title', 'API Settings')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1><i class="fas fa-key mr-2"></i>API Settings</h1>
    </div>
@stop

@section('content')
<div class="row">
    <div class="col-md-12">
        @if(session('success'))
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <h5><i class="icon fas fa-check"></i> Success!</h5>
                {{ session('success') }}
            </div>
        @endif
        
        @if(session('error'))
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <h5><i class="icon fas fa-ban"></i> Error!</h5>
                {{ session('error') }}
            </div>
        @endif
        
        <div class="card card-primary card-outline">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-cogs mr-1"></i> API Configuration</h3>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
            <form action="{{ route('settings.update-api') }}" method="POST">
                @csrf
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="api_enabled">API Status</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-toggle-on"></i></span>
                                    </div>
                                    <select class="form-control select2" id="api_enabled" name="api_enabled">
                                        <option value="1" {{ \App\Models\Setting::getValue('api_enabled', '1') == '1' ? 'selected' : '' }}>Enabled</option>
                                        <option value="0" {{ \App\Models\Setting::getValue('api_enabled', '1') == '0' ? 'selected' : '' }}>Disabled</option>
                                    </select>
                                </div>
                                <small class="form-text text-muted"><i class="fas fa-info-circle mr-1"></i> Enable or disable the entire API system</small>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="api_throttle_rate">API Rate Limit</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-tachometer-alt"></i></span>
                                    </div>
                                    <input type="number" class="form-control" id="api_throttle_rate" name="api_throttle_rate" value="{{ \App\Models\Setting::getValue('api_throttle_rate', '60') }}" min="10" max="1000" placeholder="Enter rate limit">
                                    <div class="input-group-append">
                                        <span class="input-group-text">requests per minute</span>
                                    </div>
                                </div>
                                <small class="form-text text-muted"><i class="fas fa-info-circle mr-1"></i> Maximum number of API requests allowed per minute per user</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="api_token_expiry_days">Token Expiration</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-hourglass-half"></i></span>
                                    </div>
                                    <input type="number" class="form-control" id="api_token_expiry_days" name="api_token_expiry_days" value="{{ \App\Models\Setting::getValue('api_token_expiry_days', '30') }}" min="1" max="365" placeholder="Enter days">
                                    <div class="input-group-append">
                                        <span class="input-group-text">days</span>
                                    </div>
                                </div>
                                <small class="form-text text-muted"><i class="fas fa-info-circle mr-1"></i> Number of days before API tokens expire</small>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary" data-toggle="tooltip" title="Save API configuration settings"><i class="fas fa-save mr-1"></i> Save API Settings</button>
                    <a href="{{ route('settings.index') }}" class="btn btn-default" data-toggle="tooltip" title="Return to settings menu"><i class="fas fa-times mr-1"></i> Cancel</a>
                </div>
            </form>
        </div>
        
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-mobile-alt mr-1"></i> Mobile App Integration</h3>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="alert alert-info alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                    <h5><i class="icon fas fa-info"></i> Mobile App Integration</h5>
                    <p>The API provides access to the system for the mobile application. Configure which features are available and who can access them.</p>
                    <p class="mb-0"><i class="fas fa-mobile-alt mr-1"></i> Mobile apps can connect to this system using the API endpoints.</p>
                </div>
                
                <div class="text-center mb-4">
                    <button type="button" class="btn btn-lg btn-info" data-toggle="modal" data-target="#generateDocsModal" title="Generate up-to-date API documentation">
                    <i class="fas fa-file-code mr-2"></i> Generate API Documentation
                </button>
                    <p class="text-muted mt-2"><small>Generate up-to-date API documentation for mobile app developers</small></p>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="card card-outline card-secondary">
                            <div class="card-header bg-light">
                                <h5 class="mb-0"><i class="fas fa-list mr-1"></i> Mobile App Features</h5>
                            </div>
                            <div class="card-body">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <i class="fas fa-folder-open text-primary mr-2"></i> Case Viewing
                                        </div>
                                        <span class="badge badge-success"><i class="fas fa-check mr-1"></i> Available</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <i class="fas fa-user-alt text-primary mr-2"></i> Suspect Management
                                        </div>
                                        <span class="badge badge-success"><i class="fas fa-check mr-1"></i> Available</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <i class="fas fa-fingerprint text-primary mr-2"></i> Evidence Tracking
                                        </div>
                                        <span class="badge badge-success"><i class="fas fa-check mr-1"></i> Available</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <i class="fas fa-calendar-check text-primary mr-2"></i> Bail Check-ins
                                        </div>
                                        <span class="badge badge-success"><i class="fas fa-check mr-1"></i> Available</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <i class="fas fa-user-tag text-primary mr-2"></i> Officer Assignment
                                        </div>
                                        <span class="badge badge-warning"><i class="fas fa-exclamation-triangle mr-1"></i> Limited</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <i class="fas fa-gavel text-primary mr-2"></i> Court Scheduling
                                        </div>
                                        <span class="badge badge-success"><i class="fas fa-check mr-1"></i> Available</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <i class="fas fa-chart-bar text-primary mr-2"></i> Dashboard & Reports
                                        </div>
                                        <span class="badge badge-success"><i class="fas fa-check mr-1"></i> Available</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header bg-light">
                                <h5 class="mb-0">Mobile App Configuration</h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label>API Base URL</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" value="{{ url('/api/v1') }}" readonly>
                                        <div class="input-group-append">
                                            <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('{{ url('/api/v1') }}')">
                                                <i class="fas fa-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <small class="form-text text-muted">Use this URL in the mobile app configuration</small>
                                </div>
                                
                                <div class="form-group">
                                    <label>API Documentation</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" value="{{ url('/api/documentation') }}" readonly>
                                        <div class="input-group-append">
                                            <a href="{{ url('/api/documentation') }}" target="_blank" class="btn btn-outline-primary">
                                                <i class="fas fa-external-link-alt"></i>
                                            </a>
                                        </div>
                                    </div>
                                    <small class="form-text text-muted">View the API documentation for developers</small>
                                </div>
                                
                                <div class="mt-3">
                                    <a href="{{ route('settings.generate-api-docs') }}" class="btn btn-primary">
                                        <i class="fas fa-sync mr-1"></i> Generate API Documentation
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card card-warning">
            <div class="card-header">
                <h3 class="card-title">API Security</h3>
            </div>
            <div class="card-body">
                <div class="alert alert-warning">
                    <i class="fas fa-shield-alt mr-1"></i> <strong>Important:</strong> API tokens provide access to sensitive data. Ensure proper security measures are in place.
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header bg-light">
                                <h5 class="mb-0">Security Recommendations</h5>
                            </div>
                            <div class="card-body">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item">
                                        <i class="fas fa-check-circle text-success mr-2"></i> Use HTTPS for all API communications
                                    </li>
                                    <li class="list-group-item">
                                        <i class="fas fa-check-circle text-success mr-2"></i> Implement token-based authentication
                                    </li>
                                    <li class="list-group-item">
                                        <i class="fas fa-check-circle text-success mr-2"></i> Set appropriate rate limits
                                    </li>
                                    <li class="list-group-item">
                                        <i class="fas fa-check-circle text-success mr-2"></i> Validate all input data
                                    </li>
                                    <li class="list-group-item">
                                        <i class="fas fa-check-circle text-success mr-2"></i> Implement proper error handling
                                    </li>
                                    <li class="list-group-item">
                                        <i class="fas fa-check-circle text-success mr-2"></i> Monitor API usage for suspicious activity
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="card card-outline card-secondary">
                            <div class="card-header bg-light">
                                <h5 class="mb-0"><i class="fas fa-lock mr-1"></i> API Access Control</h5>
                            </div>
                            <div class="card-body">
                                <p><i class="fas fa-users mr-1"></i> Configure which user roles have access to the API:</p>
                                <form action="{{ route('settings.update-api-access') }}" method="POST">
                                    @csrf
                                    <div class="mb-3">
                                        <div class="card bg-light">
                                            <div class="card-body py-2">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" id="api_admin_access" name="api_admin_access" value="1" {{ \App\Models\Setting::getValue('api_admin_access', '1') == '1' ? 'checked' : '' }}>
                                                    <label class="custom-control-label" for="api_admin_access"><i class="fas fa-user-shield mr-1"></i> Administrators</label>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="card bg-light mt-2">
                                            <div class="card-body py-2">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" id="api_officer_access" name="api_officer_access" value="1" {{ \App\Models\Setting::getValue('api_officer_access', '1') == '1' ? 'checked' : '' }}>
                                                    <label class="custom-control-label" for="api_officer_access"><i class="fas fa-user-tie mr-1"></i> Police Officers</label>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="card bg-light mt-2">
                                            <div class="card-body py-2">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" id="api_investigator_access" name="api_investigator_access" value="1" {{ \App\Models\Setting::getValue('api_investigator_access', '1') == '1' ? 'checked' : '' }}>
                                                    <label class="custom-control-label" for="api_investigator_access"><i class="fas fa-user-secret mr-1"></i> Investigators</label>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="card bg-light mt-2">
                                            <div class="card-body py-2">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" id="api_clerk_access" name="api_clerk_access" value="1" {{ \App\Models\Setting::getValue('api_clerk_access', '0') == '1' ? 'checked' : '' }}>
                                                    <label class="custom-control-label" for="api_clerk_access"><i class="fas fa-user-edit mr-1"></i> Clerks</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="submit" class="btn btn-primary" data-toggle="tooltip" title="Save API access permissions"><i class="fas fa-save mr-1"></i> Save Access Settings</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        function copyToClipboard(text) {
            var tempInput = document.createElement('input');
            tempInput.value = text;
            document.body.appendChild(tempInput);
            tempInput.select();
            document.execCommand('copy');
            document.body.removeChild(tempInput);
            
            // Show a temporary tooltip
            Swal.fire({
                position: 'top-end',
                icon: 'success',
                title: 'Copied to clipboard!',
                showConfirmButton: false,
                timer: 1500
            });
        }
        
        $(document).ready(function() {
            // Initialize select2
            $('.select2').select2({
                theme: 'bootstrap4'
            });
            
            // Initialize tooltips
            $('[data-toggle="tooltip"]').tooltip();
            
            // Add fade-out effect to alerts after 5 seconds
            setTimeout(function() {
                $('.alert').fadeOut('slow');
            }, 5000);
        });
    </script>
@stop

<!-- Generate API Documentation Modal -->
<div class="modal fade" id="generateDocsModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-info">
                <h4 class="modal-title"><i class="fas fa-file-code mr-1"></i> Generate API Documentation</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="callout callout-info">
                    <h5><i class="fas fa-info-circle mr-1"></i> About API Documentation</h5>
                    <p>Generating API documentation will refresh all endpoints based on the current codebase.</p>
                </div>
                
                <p class="mt-3"><strong>This is useful when:</strong></p>
                <ul class="list-group mb-3">
                    <li class="list-group-item"><i class="fas fa-code mr-2 text-primary"></i> You've made changes to API endpoints</li>
                    <li class="list-group-item"><i class="fas fa-share-alt mr-2 text-primary"></i> You need to share documentation with mobile app developers</li>
                    <li class="list-group-item"><i class="fas fa-vial mr-2 text-primary"></i> You want to test API functionality</li>
                </ul>
                
                <div class="callout callout-warning">
                    <h5><i class="fas fa-exclamation-triangle mr-1"></i> Please Note</h5>
                    <p class="mb-0">This process may take up to a minute to complete and will temporarily increase server load.</p>
                </div>
            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-default" data-dismiss="modal"><i class="fas fa-times mr-1"></i> Cancel</button>
                <a href="{{ route('settings.generate-api-docs') }}" class="btn btn-info">
                    <i class="fas fa-file-code mr-1"></i> Generate Documentation
                </a>
            </div>
        </div>
    </div>
</div>
