@extends('adminlte::page')

@section('title', 'System Logs')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1><i class="fas fa-file-alt mr-2"></i>System Logs</h1>
    </div>
@stop

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-primary card-outline">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-eye mr-1"></i> Log Viewer</h3>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
            
            @if(session('success'))
                <div class="alert alert-success alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                    <h5><i class="icon fas fa-check"></i> Success!</h5>
                    {{ session('success') }}
                </div>
            @endif
            
            @if(session('error'))
                <div class="alert alert-danger alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                    <h5><i class="icon fas fa-ban"></i> Error!</h5>
                    {{ session('error') }}
                </div>
            @endif
            
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <form action="{{ route('settings.logs') }}" method="GET" class="form-inline" id="log-selector-form">
                            <div class="form-group mr-2">
                                <label for="log" class="mr-2">Select Log File:</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-file-code"></i></span>
                                    </div>
                                    <select name="log" id="log" class="form-control select2">
                                    @foreach($logFiles as $logFile)
                                        <option value="{{ $logFile }}" {{ $selectedLog == $logFile ? 'selected' : '' }}>
                                            {{ $logFile }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-6 text-right">
                        <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#clearLogModal" data-toggle="tooltip" title="Clear current log file">
                            <i class="fas fa-trash mr-1"></i> Clear Log
                        </button>
                        <button type="button" class="btn btn-info btn-sm refresh-log" data-toggle="tooltip" title="Refresh Log Content">
                            <i class="fas fa-sync-alt mr-1"></i> Refresh
                        </button>
                        <button type="button" class="btn btn-success btn-sm" id="download-log" data-toggle="tooltip" title="Download log file">
                            <i class="fas fa-download mr-1"></i> Download
                        </button>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="log-container bg-dark p-3 text-white" style="height: 600px; overflow-y: auto; font-family: monospace; font-size: 12px; white-space: pre-wrap;">
                            @if(!empty($logContent))
                                {!! nl2br(e($logContent)) !!}
                            @else
                                <p>No log content available or log file is empty.</p>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-cog mr-1"></i> Log Settings</h3>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('settings.update-log-settings') }}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="log_level">Log Level</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-level-up-alt"></i></span>
                                    </div>
                                    <select class="form-control select2" id="log_level" name="log_level">
                                    <option value="debug" {{ \App\Models\Setting::getValue('log_level', 'debug') == 'debug' ? 'selected' : '' }}>Debug (All Messages)</option>
                                    <option value="info" {{ \App\Models\Setting::getValue('log_level', 'debug') == 'info' ? 'selected' : '' }}>Info</option>
                                    <option value="warning" {{ \App\Models\Setting::getValue('log_level', 'debug') == 'warning' ? 'selected' : '' }}>Warning</option>
                                    <option value="error" {{ \App\Models\Setting::getValue('log_level', 'debug') == 'error' ? 'selected' : '' }}>Error</option>
                                    <option value="critical" {{ \App\Models\Setting::getValue('log_level', 'debug') == 'critical' ? 'selected' : '' }}>Critical</option>
                                    </select>
                                </div>
                                <small class="form-text text-muted"><i class="fas fa-info-circle mr-1"></i> Set the minimum level of messages that should be logged</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="log_retention_days">Log Retention (days)</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-calendar-times"></i></span>
                                    </div>
                                    <input type="number" class="form-control" id="log_retention_days" name="log_retention_days" value="{{ \App\Models\Setting::getValue('log_retention_days', 30) }}" min="1" max="365" placeholder="Enter days to retain logs">
                                </div>
                                <small class="form-text text-muted"><i class="fas fa-info-circle mr-1"></i> Logs older than this will be automatically deleted</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="log_activity_enabled">Activity Logging</label>
                                <select class="form-control" id="log_activity_enabled" name="log_activity_enabled">
                                    <option value="1" {{ \App\Models\Setting::getValue('log_activity_enabled', '1') == '1' ? 'selected' : '' }}>Enabled</option>
                                    <option value="0" {{ \App\Models\Setting::getValue('log_activity_enabled', '1') == '0' ? 'selected' : '' }}>Disabled</option>
                                </select>
                                <small class="form-text text-muted">Log user activities like login, logout, and data modifications</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Automatic Cleanup</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-broom"></i></span>
                                    </div>
                                    <div class="form-control bg-light">
                                        <div class="custom-control custom-switch">
                                            <input type="checkbox" class="custom-control-input" id="log_enable_daily_cleanup" name="log_enable_daily_cleanup" {{ \App\Models\Setting::getValue('log_enable_daily_cleanup', 'false') === 'true' ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="log_enable_daily_cleanup">Enable automatic daily log cleanup</label>
                                        </div>
                                    </div>
                                </div>
                                <small class="form-text text-muted"><i class="fas fa-info-circle mr-1"></i> When enabled, old logs will be deleted according to the retention period</small>
                            </div>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary" data-toggle="tooltip" title="Save log configuration settings"><i class="fas fa-save mr-1"></i> Save Log Settings</button>
                    <a href="{{ route('settings.index') }}" class="btn btn-default" data-toggle="tooltip" title="Return to settings menu"><i class="fas fa-times mr-1"></i> Cancel</a>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Clear Log Modal -->
<div class="modal fade" id="clearLogModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger">
                <h4 class="modal-title">Confirm Clear Log</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to clear the log file "{{ $selectedLog }}"?</p>
                <p>This action cannot be undone.</p>
            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-default" data-dismiss="modal"><i class="fas fa-times mr-1"></i> Cancel</button>
                <a href="{{ url('/settings/logs/clear/' . $selectedLog) }}" class="btn btn-danger clear-log-btn"><i class="fas fa-trash mr-1"></i> Clear Log</a>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        $(document).ready(function() {
            // Initialize select2
            $('.select2').select2({
                theme: 'bootstrap4'
            });
            
            // Initialize tooltips
            $('[data-toggle="tooltip"]').tooltip();
            
            // Auto-scroll to the bottom of the log container
            var logContainer = $('.log-container');
            logContainer.scrollTop(logContainer.prop('scrollHeight'));
            
            // Function to load log content
            function loadLogContent(selectedLog) {
                // Show loading indicator
                logContainer.html('<div class="text-center"><i class="fas fa-spinner fa-spin"></i> Loading log content...</div>');
                
                // Fetch log content via AJAX
                $.ajax({
                    url: '{{ route("settings.view-log") }}',
                    data: { filename: selectedLog },
                    success: function(response) {
                        if (response.content) {
                            // Replace newlines with <br> tags and escape HTML
                            var content = response.content.replace(/&/g, '&amp;')
                                .replace(/</g, '&lt;')
                                .replace(/>/g, '&gt;')
                                .replace(/"/g, '&quot;')
                                .replace(/'/g, '&#039;')
                                .replace(/\n/g, '<br>');
                            logContainer.html(content);
                        } else {
                            logContainer.html('<p>No log content available or log file is empty.</p>');
                        }
                        // Scroll to bottom
                        logContainer.scrollTop(logContainer.prop('scrollHeight'));
                        
                        // Update the clear log button href
                        $('.clear-log-btn').attr('href', '{{ url("/settings/logs/clear") }}/' + encodeURIComponent(selectedLog));
                    },
                    error: function() {
                        logContainer.html('<p class="text-danger">Error loading log file. Please try again.</p>');
                    }
                });
            }
            
            // Handle log file selection change via AJAX
            $('#log').change(function() {
                var selectedLog = $(this).val();
                
                // Update URL parameter without page reload
                var url = new URL(window.location.href);
                url.searchParams.set('log', selectedLog);
                window.history.pushState({}, '', url);
                
                // Load log content
                loadLogContent(selectedLog);
                
                return false; // Prevent form submission
            });
            
            // Handle refresh button click
            $('.refresh-log').click(function() {
                var selectedLog = $('#log').val();
                loadLogContent(selectedLog);
            });
            
            // Handle download button click
            $('#download-log').click(function() {
                var selectedLog = $('#log').val();
                window.location.href = '{{ url("/settings/logs/download") }}?filename=' + encodeURIComponent(selectedLog);
            });
            
            // Add fade-out effect to alerts after 5 seconds
            setTimeout(function() {
                $('.alert').fadeOut('slow');
            }, 5000);
        });
    </script>
@stop
