@extends('adminlte::page')

@section('title', 'Police Station Details')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>{{ $station->name }} 
            @if ($station->is_headquarters)
                <span class="badge badge-primary">Headquarters</span>
            @endif
        </h1>
        <div>
            <a href="{{ route('stations.edit', $station) }}" class="btn btn-warning">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="{{ route('stations.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to List
            </a>
        </div>
    </div>
@stop

@section('content')
    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Station Information</h3>
                </div>
                <div class="card-body">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 30%">Station Code</th>
                            <td>{{ $station->code }}</td>
                        </tr>
                        <tr>
                            <th>Status</th>
                            <td>
                                @if ($station->is_active)
                                    <span class="badge badge-success">Active</span>
                                @else
                                    <span class="badge badge-danger">Inactive</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Address</th>
                            <td>{{ $station->address }}</td>
                        </tr>
                        <tr>
                            <th>City</th>
                            <td>{{ $station->city }}</td>
                        </tr>
                        <tr>
                            <th>Region</th>
                            <td>{{ $station->region }}</td>
                        </tr>
                        <tr>
                            <th>Phone</th>
                            <td>{{ $station->phone ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Email</th>
                            <td>{{ $station->email ?? 'N/A' }}</td>
                        </tr>
                    </table>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Station Description</h3>
                </div>
                <div class="card-body">
                    {{ $station->description ?? 'No description available.' }}
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Station Commander</h3>
                </div>
                <div class="card-body">
                    @if ($station->commander)
                        <div class="d-flex align-items-center">
                            <div class="mr-3">
                                <img class="profile-user-img img-fluid img-circle" 
                                     src="{{ asset('img/user-profile.png') }}" 
                                     alt="Commander profile picture">
                            </div>
                            <div>
                                <h4>{{ $station->commander->name }}</h4>
                                <p class="text-muted mb-0">
                                    {{ $station->commander->rank ?? 'No rank' }}
                                    @if ($station->commander->badge_number)
                                        <span class="badge badge-info">{{ $station->commander->badge_number }}</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                    @else
                        <p>No commander assigned to this station.</p>
                    @endif
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Officers Assigned</h3>
                </div>
                <div class="card-body">
                    @if ($station->officers->count() > 0)
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Rank</th>
                                    <th>Badge Number</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($station->officers as $officer)
                                    <tr>
                                        <td>{{ $officer->name }}</td>
                                        <td>{{ $officer->rank ?? 'N/A' }}</td>
                                        <td>{{ $officer->badge_number ?? 'N/A' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <p>No officers assigned to this station.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script>
        console.log('Police Station Details page loaded!');
    </script>
@stop
