<?php

use App\Http\Controllers\Api\AuthController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Public routes
Route::post('/login', [AuthController::class, 'login']);
Route::post('/refresh-token', [AuthController::class, 'refreshToken']);

// Protected routes
Route::middleware('auth:sanctum')->group(function () {
    // User info
    Route::get('/user', function (Request $request) {
        return $request->user();
    });
    
    // Logout
    Route::post('/logout', [AuthController::class, 'logout']);
    
    // Bail check-ins
    Route::get('/bail-checkins', [AuthController::class, 'getBailCheckins']);
    Route::get('/bail-checkins/today', [AuthController::class, 'getTodayBailCheckins']);
    Route::post('/bail-checkins', [AuthController::class, 'storeBailCheckin']);
    
    // Cases
    Route::get('/cases', [AuthController::class, 'getCases']);
    Route::get('/cases/{id}', [AuthController::class, 'getCase']);
    
    // Evidence
    Route::get('/evidence', [AuthController::class, 'getEvidence']);
    Route::post('/evidence/upload', [AuthController::class, 'uploadEvidence']);
});
