<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\PoliceStationController;
use App\Http\Controllers\OfficerController;
use App\Http\Controllers\CaseController;
use App\Http\Controllers\CaseEvidenceController;
use App\Http\Controllers\CaseVictimController;
use App\Http\Controllers\CaseSuspectController;
use App\Http\Controllers\CaseStatementController;
use App\Http\Controllers\CaseUpdateController;
use App\Http\Controllers\CaseReportController;
use App\Http\Controllers\CaseStatisticsController;
use App\Http\Controllers\EvidenceTransferController;
use App\Http\Controllers\EvidenceController;
use App\Http\Controllers\BailApplicationController;
use App\Http\Controllers\BailCheckinController;
use App\Http\Controllers\ReportsController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\Api\AuthController;
use Illuminate\Support\Facades\Route;
use Laravel\Sanctum\Http\Controllers\CsrfCookieController;

// Sanctum CSRF Cookie Route
Route::get('/sanctum/csrf-cookie', [CsrfCookieController::class, 'show']);

// Temporary API routes for testing
Route::post('/api/login', [AuthController::class, 'login']);
Route::post('/api/refresh-token', [AuthController::class, 'refreshToken']);

Route::get('/', function () {
    return redirect()->route('dashboard');
});

Route::get('/dashboard', [DashboardController::class, 'index'])->middleware(['auth', \App\Http\Middleware\StationDataFilterMiddleware::class])->name('dashboard');

Route::middleware(['auth', \App\Http\Middleware\StationDataFilterMiddleware::class])->group(function () {
    // Profile routes
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    
    // Police Station routes
    Route::resource('stations', PoliceStationController::class);
    
    // Officer management routes
    Route::resource('officers', OfficerController::class);
    Route::get('/officers-assign', [OfficerController::class, 'assignBatch'])->name('officers.assign-batch');
    Route::post('/officers-assign', [OfficerController::class, 'processBatchAssignment'])->name('officers.process-batch-assignment');
    
    // Case management routes
    Route::resource('cases', CaseController::class);
    
    // Case Evidence routes
    Route::resource('case-evidences', CaseEvidenceController::class);
    Route::post('/case-evidences/{id}/update-custody', [CaseEvidenceController::class, 'updateCustody'])->name('case-evidences.update-custody');
    Route::post('/case-evidences/{id}/remove-photo', [CaseEvidenceController::class, 'removePhoto'])->name('case-evidences.remove-photo');
    Route::post('/case-evidences/{id}/remove-document', [CaseEvidenceController::class, 'removeDocument'])->name('case-evidences.remove-document');
    
    // Case Victim routes
    Route::resource('case-victims', CaseVictimController::class);
    Route::post('/case-victims/{id}/update-protection', [CaseVictimController::class, 'updateProtection'])->name('case-victims.update-protection');
    
    // Case Suspect routes
    Route::resource('case-suspects', CaseSuspectController::class);
    Route::put('/case-suspects/{id}/update-arrest', [CaseSuspectController::class, 'updateArrest'])->name('case-suspects.update-arrest');
    Route::put('/case-suspects/{id}/update-charge', [CaseSuspectController::class, 'updateCharge'])->name('case-suspects.update-charge');
    Route::put('/case-suspects/{id}/update-custody', [CaseSuspectController::class, 'updateCustody'])->name('case-suspects.update-custody');
    
    // Case Statement routes
    Route::resource('case-statements', CaseStatementController::class);
    Route::post('/case-statements/{id}/verify', [CaseStatementController::class, 'verify'])->name('case-statements.verify');
    
    // Case Update routes
    Route::resource('case-updates', CaseUpdateController::class);
    
    // Case Reports Routes
    Route::prefix('case-reports')->name('case-reports.')->middleware(['auth'])->group(function () {
        Route::get('/', [CaseReportController::class, 'index'])->name('index');
        Route::post('/generate', [CaseReportController::class, 'generate'])->name('generate');
    });
    
    // Case Statistics Routes
    Route::get('/case-statistics', [CaseStatisticsController::class, 'index'])->name('case-statistics');
    Route::get('/case-by-station', [CaseStatisticsController::class, 'byStation'])->name('case-by-station');
    Route::get('/case-by-officer', [CaseStatisticsController::class, 'byOfficer'])->name('case-by-officer');
    Route::get('/case-by-crime', [CaseStatisticsController::class, 'byCrimeType'])->name('case-by-crime');

    // Evidence Transfer routes
    Route::resource('evidence-transfers', EvidenceTransferController::class);
    
    // Evidence Management Routes
    Route::resource('evidence', EvidenceController::class);
    Route::post('evidence/{id}/transfer', [EvidenceController::class, 'transfer'])->name('evidence.transfer');
    Route::delete('evidence/{id}/photos', [EvidenceController::class, 'removePhoto'])->name('evidence.remove-photo');
    Route::delete('evidence/{id}/documents', [EvidenceController::class, 'removeDocument'])->name('evidence.remove-document');
    
    // Bail Management Routes
    Route::resource('bail', BailApplicationController::class);
    Route::get('bail/get-suspects', [BailApplicationController::class, 'getSuspects'])->name('bail.get-suspects');
    Route::patch('bail/{bail}/update-status', [BailApplicationController::class, 'updateStatus'])->name('bail.update-status');
    Route::patch('bail/condition/{condition}', [BailApplicationController::class, 'updateCondition'])->name('bail.update-condition');
    
    // Bail Check-in Routes
    Route::resource('bail-checkins', BailCheckinController::class);
    Route::get('bail-checkins-today', [BailCheckinController::class, 'todayCheckins'])->name('bail-checkins.today');
    Route::get('bail-checkins-stats', [BailCheckinController::class, 'reportingStats'])->name('bail-checkins.stats');
    
    // Reports & Analytics Routes
    Route::get('reports/statistics', [ReportsController::class, 'statistics'])->name('reports.statistics');
    Route::get('reports/performance', [ReportsController::class, 'performance'])->name('reports.performance');
    Route::get('reports/stations', [ReportsController::class, 'stations'])->name('reports.stations');
    
    // Settings Routes
    Route::prefix('settings')->name('settings.')->middleware(['auth'])->group(function () {
        // Settings Index
        Route::get('/', [SettingsController::class, 'index'])->name('index');
        
        // General Settings
        Route::get('/general', [SettingsController::class, 'general'])->name('general');
        Route::post('/general', [SettingsController::class, 'updateGeneral'])->name('update-general');
        
        // Backup Settings
        Route::get('/backup', [SettingsController::class, 'backup'])->name('backup');
        Route::post('/backup/create', [SettingsController::class, 'createBackup'])->name('create-backup');
        Route::get('/backup/download/{filename}', [SettingsController::class, 'downloadBackup'])->name('download-backup');
        Route::post('/backup/restore/{filename}', [SettingsController::class, 'restoreBackup'])->name('restore-backup');
        Route::delete('/backup/{filename}', [SettingsController::class, 'deleteBackup'])->name('delete-backup');
        Route::post('/backup/settings', [SettingsController::class, 'updateBackupSettings'])->name('update-backup-settings');
        
        // Logs Settings
        Route::get('/logs', [SettingsController::class, 'logs'])->name('logs');
        Route::get('/logs/view', [SettingsController::class, 'viewLog'])->name('view-log');
        Route::get('/logs/clear/{filename}', [SettingsController::class, 'clearLog'])->name('clear-log');
        Route::get('/logs/download', [SettingsController::class, 'downloadLog'])->name('download-log');
        Route::post('/logs/settings', [SettingsController::class, 'updateLogSettings'])->name('update-log-settings');
        
        // Roles & Permissions Settings
        Route::get('/roles', [SettingsController::class, 'roles'])->name('roles');
        Route::post('/roles', [SettingsController::class, 'createRole'])->name('create-role');
        Route::post('/roles/{id}', [SettingsController::class, 'updateRole'])->name('update-role');
        Route::delete('/roles/{id}', [SettingsController::class, 'deleteRole'])->name('delete-role');
        
        // API Settings
        Route::get('/api', [SettingsController::class, 'api'])->name('api');
        Route::post('/api', [SettingsController::class, 'updateApi'])->name('update-api');
        Route::post('/api/access', [SettingsController::class, 'updateApiAccess'])->name('update-api-access');
        Route::get('/api/generate-docs', [SettingsController::class, 'generateApiDocs'])->name('generate-api-docs');
    });
});

require __DIR__.'/auth.php';
