<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content_header'); ?>
    <div class="row">
        <div class="col-sm-6">
            <h1>Dashboard</h1>
        </div>
        <div class="col-sm-6">
            <div class="float-right">
                <span class="badge badge-info p-2">
                    <i class="fas fa-user"></i> <?php echo e($dashboardData['user_info']['rank']); ?>

                </span>
                <?php if($dashboardData['user_info']['badge_number']): ?>
                    <span class="badge badge-secondary p-2 ml-1">
                        <i class="fas fa-id-badge"></i> <?php echo e($dashboardData['user_info']['badge_number']); ?>

                    </span>
                <?php endif; ?>
                <span class="badge badge-primary p-2 ml-1">
                    <i class="fas fa-building"></i> <?php echo e($dashboardData['user_info']['station']); ?>

                </span>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- User Context Information -->
    <div class="row mb-3">
        <div class="col-12">
            <div class="alert alert-info">
                <h5><i class="icon fas fa-info-circle"></i> Your Access Level</h5>
                <p class="mb-1">
                    <strong>Rank:</strong> <?php echo e($dashboardData['user_info']['rank']); ?> 
                    (Level <?php echo e($dashboardData['user_info']['rank_level']); ?>)
                </p>
                <p class="mb-1">
                    <strong>Station Access:</strong> 
                    <?php if($dashboardData['user_info']['has_multi_station_access']): ?>
                        <span class="badge badge-success">All Stations</span>
                    <?php else: ?>
                        <span class="badge badge-warning"><?php echo e($dashboardData['user_info']['station']); ?> Only</span>
                    <?php endif; ?>
                </p>
                <p class="mb-0">
                    <strong>Data Scope:</strong> 
                    <?php if($dashboardData['user_info']['is_admin']): ?>
                        <span class="badge badge-danger">System Administrator - Full Access</span>
                    <?php elseif($dashboardData['user_info']['has_multi_station_access']): ?>
                        All police stations and their data
                    <?php else: ?>
                        Limited to <?php echo e($dashboardData['user_info']['station']); ?> station data only
                    <?php endif; ?>
                </p>
            </div>
        </div>
    </div>

    <!-- Core Statistics -->
    <?php if(!empty($stats)): ?>
        <div class="row">
            <?php $__currentLoopData = $stats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $statGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(is_array($statGroup) && isset($statGroup['label'])): ?>
                    <!-- Single Stat Card -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-<?php echo e($statGroup['color']); ?>">
                            <div class="inner">
                                <?php if($key === 'cases'): ?>
                                    <h3><?php echo e($statGroup['total']); ?></h3>
                                    <p><?php echo e($statGroup['label']); ?></p>
                                    <small>
                                        Active: <?php echo e($statGroup['active']); ?> | 
                                        Closed: <?php echo e($statGroup['closed']); ?> | 
                                        Pending: <?php echo e($statGroup['pending']); ?>

                                    </small>
                                <?php elseif($key === 'evidence'): ?>
                                    <h3><?php echo e($statGroup['total']); ?></h3>
                                    <p><?php echo e($statGroup['label']); ?></p>
                                    <small>
                                        In Custody: <?php echo e($statGroup['in_custody']); ?> | 
                                        In Analysis: <?php echo e($statGroup['in_analysis']); ?>

                                    </small>
                                <?php elseif($key === 'bail'): ?>
                                    <h3><?php echo e($statGroup['pending']); ?></h3>
                                    <p>Pending <?php echo e($statGroup['label']); ?></p>
                                    <small>
                                        Approved: <?php echo e($statGroup['approved']); ?> | 
                                        Rejected: <?php echo e($statGroup['rejected']); ?> | 
                                        Today's Check-ins: <?php echo e($statGroup['today_checkins']); ?>

                                    </small>
                                <?php else: ?>
                                    <h3><?php echo e($statGroup['total']); ?></h3>
                                    <p><?php echo e($statGroup['label']); ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="icon">
                                <i class="<?php echo e($statGroup['icon']); ?>"></i>
                            </div>
                            <a href="#" class="small-box-footer">
                                View Details <i class="fas fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>

    <!-- Intelligent Alerts -->
    <?php if(!empty($alerts)): ?>
        <div class="row">
            <div class="col-12">
                <div class="card card-warning">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-exclamation-triangle mr-1"></i>
                            Alerts & Notifications
                        </h3>
                    </div>
                    <div class="card-body">
                        <?php $__currentLoopData = $alerts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="alert alert-<?php echo e($alert['type']); ?> alert-dismissible">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                <h5>
                                    <i class="icon fas fa-<?php echo e($alert['type'] === 'danger' ? 'ban' : ($alert['type'] === 'warning' ? 'exclamation-triangle' : 'info-circle')); ?>"></i> 
                                    <?php echo e($alert['title']); ?>

                                </h5>
                                <p><?php echo e($alert['message']); ?></p>
                                <?php if(isset($alert['action_url'])): ?>
                                    <a href="<?php echo e($alert['action_url']); ?>" class="btn btn-<?php echo e($alert['type']); ?> btn-sm">
                                        Take Action
                                    </a>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Quick Actions -->
    <?php if(!empty($quickActions)): ?>
        <div class="row">
            <div class="col-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-bolt mr-1"></i>
                            Quick Actions
                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <?php $__currentLoopData = $quickActions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
                                    <a href="<?php echo e($action['url']); ?>" class="btn btn-<?php echo e($action['color']); ?> btn-block">
                                        <i class="<?php echo e($action['icon']); ?>"></i><br>
                                        <small><?php echo e($action['title']); ?></small>
                                    </a>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Rank-Specific Sections -->
    <?php if(!empty($sections)): ?>
        <div class="row">
            <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sectionKey => $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($section['show']): ?>
                    <?php if($sectionKey === 'my_cases'): ?>
                        <!-- My Assigned Cases -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-folder mr-1"></i>
                                        <?php echo e($section['title']); ?>

                                    </h3>
                                </div>
                                <div class="card-body p-0">
                                    <?php if($section['data']->isEmpty()): ?>
                                        <div class="alert alert-info m-3">
                                            <i class="fas fa-info-circle"></i> No cases assigned to you.
                                        </div>
                                    <?php else: ?>
                                        <ul class="products-list product-list-in-card pl-2 pr-2">
                                            <?php $__currentLoopData = $section['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $case): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="item">
                                                    <div class="product-info">
                                                        <a href="<?php echo e(route('cases.show', $case->id)); ?>" class="product-title">
                                                            #<?php echo e($case->case_number); ?> - <?php echo e($case->title); ?>

                                                            <?php switch($case->status):
                                                                case ('active'): ?>
                                                                    <span class="badge badge-success float-right">Active</span>
                                                                    <?php break; ?>
                                                                <?php case ('pending'): ?>
                                                                    <span class="badge badge-warning float-right">Pending</span>
                                                                    <?php break; ?>
                                                                <?php case ('closed'): ?>
                                                                    <span class="badge badge-secondary float-right">Closed</span>
                                                                    <?php break; ?>
                                                                <?php default: ?>
                                                                    <span class="badge badge-dark float-right"><?php echo e(ucfirst($case->status)); ?></span>
                                                            <?php endswitch; ?>
                                                        </a>
                                                        <span class="product-description">
                                                            <?php echo e(Str::limit($case->description, 100)); ?>

                                                        </span>
                                                        <small class="text-muted">
                                                            <i class="fas fa-calendar"></i> <?php echo e($case->created_at->format('M d, Y')); ?> |
                                                            <i class="fas fa-building"></i> <?php echo e($case->station->name ?? 'Unknown'); ?>

                                                        </small>
                                                    </div>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    <?php endif; ?>
                                </div>
                                <div class="card-footer text-center">
                                    <a href="<?php echo e(route('cases.index', ['assigned_to_me' => true])); ?>" class="text-sm">View All My Cases</a>
                                </div>
                            </div>
                        </div>

                    <?php elseif($sectionKey === 'evidence_status'): ?>
                        <!-- Evidence Status Overview -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-box mr-1"></i>
                                        <?php echo e($section['title']); ?>

                                    </h3>
                                </div>
                                <div class="card-body">
                                    <?php if($section['data']->isEmpty()): ?>
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle"></i> No evidence data available.
                                        </div>
                                    <?php else: ?>
                                        <div class="row">
                                            <?php $__currentLoopData = $section['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-6 text-center">
                                                    <div class="info-box">
                                                        <span class="info-box-icon bg-info">
                                                            <i class="fas fa-box"></i>
                                                        </span>
                                                        <div class="info-box-content">
                                                            <span class="info-box-text"><?php echo e(ucfirst(str_replace('_', ' ', $status->status))); ?></span>
                                                            <span class="info-box-number"><?php echo e($status->count); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                    <?php elseif($sectionKey === 'station_overview'): ?>
                        <!-- Station Performance -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-chart-line mr-1"></i>
                                        <?php echo e($section['title']); ?>

                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-4 text-center">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-primary">
                                                    <i class="fas fa-plus"></i>
                                                </span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Cases This Month</span>
                                                    <span class="info-box-number"><?php echo e($section['data']['cases_this_month']); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-4 text-center">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-success">
                                                    <i class="fas fa-check"></i>
                                                </span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Solved This Month</span>
                                                    <span class="info-box-number"><?php echo e($section['data']['solved_this_month']); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-4 text-center">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-warning">
                                                    <i class="fas fa-percentage"></i>
                                                </span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Clearance Rate</span>
                                                    <span class="info-box-number"><?php echo e($section['data']['clearance_rate']); ?>%</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    <?php elseif($sectionKey === 'bail_management'): ?>
                        <!-- Bail Applications Requiring Attention -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-gavel mr-1"></i>
                                        <?php echo e($section['title']); ?>

                                    </h3>
                                </div>
                                <div class="card-body p-0">
                                    <?php if($section['data']->isEmpty()): ?>
                                        <div class="alert alert-success m-3">
                                            <i class="fas fa-check-circle"></i> No pending bail applications.
                                        </div>
                                    <?php else: ?>
                                        <ul class="products-list product-list-in-card pl-2 pr-2">
                                            <?php $__currentLoopData = $section['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="item">
                                                    <div class="product-info">
                                                        <a href="<?php echo e(route('bail.show', $bail->id)); ?>" class="product-title">
                                                            Bail Application #<?php echo e($bail->id); ?>

                                                            <span class="badge badge-warning float-right">Pending</span>
                                                        </a>
                                                        <span class="product-description">
                                                            Case: #<?php echo e($bail->case->case_number ?? 'Unknown'); ?> - <?php echo e($bail->case->title ?? 'Unknown Case'); ?>

                                                        </span>
                                                        <small class="text-muted">
                                                            <i class="fas fa-calendar"></i> Applied <?php echo e($bail->created_at->diffForHumans()); ?> |
                                                            <i class="fas fa-user"></i> <?php echo e($bail->suspect->name ?? 'Unknown Suspect'); ?>

                                                        </small>
                                                    </div>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    <?php endif; ?>
                                </div>
                                <div class="card-footer text-center">
                                    <a href="<?php echo e(route('bail.index', ['status' => 'pending'])); ?>" class="text-sm">View All Pending Applications</a>
                                </div>
                            </div>
                        </div>

                    <?php elseif($sectionKey === 'officer_performance'): ?>
                        <!-- Top Performing Officers -->
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-trophy mr-1"></i>
                                        <?php echo e($section['title']); ?>

                                    </h3>
                                </div>
                                <div class="card-body">
                                    <?php if($section['data']->isEmpty()): ?>
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle"></i> No officer performance data available.
                                        </div>
                                    <?php else: ?>
                                        <div class="row">
                                            <?php $__currentLoopData = $section['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $officer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-md-2 col-sm-4 text-center">
                                                    <div class="position-relative">
                                                        <img src="<?php echo e($officer->adminlte_image()); ?>" class="img-circle elevation-2" alt="User Image" style="width: 80px; height: 80px; object-fit: cover;">
                                                        <div class="badge badge-success position-absolute" style="top: 0; right: 0;">
                                                            <?php echo e($officer->lead_investigator_cases_count); ?> cases
                                                        </div>
                                                    </div>
                                                    <h6 class="mt-2">
                                                        <a href="<?php echo e(route('officers.show', $officer->id)); ?>"><?php echo e($officer->name); ?></a>
                                                    </h6>
                                                    <small class="text-muted"><?php echo e($officer->rank); ?></small>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                    <?php elseif($sectionKey === 'multi_station_overview'): ?>
                        <!-- Multi-Station Overview -->
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-building mr-1"></i>
                                        <?php echo e($section['title']); ?>

                                    </h3>
                                </div>
                                <div class="card-body">
                                    <?php if($section['data']->isEmpty()): ?>
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle"></i> No station data available.
                                        </div>
                                    <?php else: ?>
                                        <div class="row">
                                            <?php $__currentLoopData = $section['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $station): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-md-3 col-sm-6">
                                                    <div class="info-box">
                                                        <span class="info-box-icon bg-info">
                                                            <i class="fas fa-building"></i>
                                                        </span>
                                                        <div class="info-box-content">
                                                            <span class="info-box-text"><?php echo e($station->name); ?></span>
                                                            <span class="info-box-number"><?php echo e($station->cases_count); ?> cases</span>
                                                            <div class="progress">
                                                                <div class="progress-bar" style="width: <?php echo e(min(100, ($station->cases_count / max(1, $section['data']->max('cases_count'))) * 100)); ?>%"></div>
                                                            </div>
                                                            <span class="progress-description"><?php echo e($station->officers_count); ?> officers</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                    <?php elseif($sectionKey === 'station_performance_comparison'): ?>
                        <!-- Station Performance Comparison (Assistant Superintendent+) -->
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-chart-line mr-1"></i>
                                        <?php echo e($section['title']); ?>

                                    </h3>
                                </div>
                                <div class="card-body">
                                    <?php if($section['data']->isEmpty()): ?>
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle"></i> No station performance data available.
                                        </div>
                                    <?php else: ?>
                                        <div class="row">
                                            <?php $__currentLoopData = $section['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $station): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-lg-3 col-md-4 col-sm-6">
                                                    <div class="info-box">
                                                        <span class="info-box-icon bg-<?php echo e($station->clearance_rate >= 70 ? 'success' : ($station->clearance_rate >= 50 ? 'warning' : 'danger')); ?>">
                                                            <i class="fas fa-building"></i>
                                                        </span>
                                                        <div class="info-box-content">
                                                            <span class="info-box-text"><?php echo e($station->name); ?></span>
                                                            <span class="info-box-number"><?php echo e($station->clearance_rate); ?>%</span>
                                                            <div class="progress">
                                                                <div class="progress-bar bg-<?php echo e($station->clearance_rate >= 70 ? 'success' : ($station->clearance_rate >= 50 ? 'warning' : 'danger')); ?>" 
                                                                     style="width: <?php echo e($station->clearance_rate); ?>%"></div>
                                                            </div>
                                                            <span class="progress-description">
                                                                <?php echo e($station->total_cases); ?> cases | <?php echo e($station->officers); ?> officers
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                    <?php elseif($sectionKey === 'critical_cases_attention'): ?>
                        <!-- Critical Cases Requiring Attention -->
                        <div class="col-md-6">
                            <div class="card card-danger">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-exclamation-triangle mr-1"></i>
                                        <?php echo e($section['title']); ?>

                                    </h3>
                                </div>
                                <div class="card-body p-0">
                                    <?php if($section['data']->isEmpty()): ?>
                                        <div class="alert alert-success m-3">
                                            <i class="fas fa-check-circle"></i> No critical cases requiring immediate attention.
                                        </div>
                                    <?php else: ?>
                                        <ul class="products-list product-list-in-card pl-2 pr-2">
                                            <?php $__currentLoopData = $section['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $case): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="item">
                                                    <div class="product-info">
                                                        <a href="<?php echo e(route('cases.show', $case->id)); ?>" class="product-title">
                                                            #<?php echo e($case->case_number); ?> - <?php echo e($case->title); ?>

                                                            <span class="badge badge-<?php echo e($case->priority === 'high' ? 'danger' : ($case->priority === 'medium' ? 'warning' : 'info')); ?> float-right">
                                                                <?php echo e(ucfirst($case->priority)); ?> Priority
                                                            </span>
                                                        </a>
                                                        <span class="product-description">
                                                            <?php echo e(Str::limit($case->description, 80)); ?>

                                                        </span>
                                                        <small class="text-muted">
                                                            <i class="fas fa-calendar"></i> <?php echo e($case->created_at->diffForHumans()); ?> |
                                                            <i class="fas fa-building"></i> <?php echo e($case->station->name ?? 'Unknown'); ?> |
                                                            <i class="fas fa-user"></i> <?php echo e($case->leadInvestigator->name ?? 'Unassigned'); ?>

                                                        </small>
                                                    </div>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    <?php endif; ?>
                                </div>
                                <div class="card-footer text-center">
                                    <a href="<?php echo e(route('cases.index', ['priority' => 'high'])); ?>" class="text-sm">View All High Priority Cases</a>
                                </div>
                            </div>
                        </div>

                    <?php elseif($sectionKey === 'resource_allocation_analysis'): ?>
                        <!-- Resource Allocation Analysis -->
                        <div class="col-md-6">
                            <div class="card card-info">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-users mr-1"></i>
                                        <?php echo e($section['title']); ?>

                                    </h3>
                                </div>
                                <div class="card-body">
                                    <?php if(isset($section['data']['officer_workload'])): ?>
                                        <div class="info-box">
                                            <span class="info-box-icon bg-primary">
                                                <i class="fas fa-user-tie"></i>
                                            </span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Average Officer Workload</span>
                                                <span class="info-box-number"><?php echo e($section['data']['officer_workload']); ?> cases</span>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <?php if(isset($section['data']['evidence_backlog'])): ?>
                                        <div class="info-box">
                                            <span class="info-box-icon bg-warning">
                                                <i class="fas fa-box"></i>
                                            </span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Evidence Backlog</span>
                                                <span class="info-box-number"><?php echo e($section['data']['evidence_backlog']); ?> items</span>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <?php if(isset($section['data']['pending_bail'])): ?>
                                        <div class="info-box">
                                            <span class="info-box-icon bg-info">
                                                <i class="fas fa-gavel"></i>
                                            </span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Pending Bail Applications</span>
                                                <span class="info-box-number"><?php echo e($section['data']['pending_bail']); ?></span>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                    <?php elseif($sectionKey === 'monthly_performance_trends'): ?>
                        <!-- Monthly Performance Trends -->
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-chart-area mr-1"></i>
                                        <?php echo e($section['title']); ?>

                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <!-- Case Resolution Trend -->
                                        <?php if(isset($section['data']['case_resolution_trend'])): ?>
                                            <div class="col-md-4">
                                                <h5>Case Resolution Trend</h5>
                                                <canvas id="caseResolutionChart" width="400" height="200"></canvas>
                                            </div>
                                        <?php endif; ?>

                                        <!-- Crime Type Distribution -->
                                        <?php if(isset($section['data']['crime_type_distribution'])): ?>
                                            <div class="col-md-4">
                                                <h5>Crime Type Distribution</h5>
                                                <?php $__currentLoopData = $section['data']['crime_type_distribution']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crime): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="progress-group">
                                                        <?php echo e($crime['type']); ?>

                                                        <span class="float-right"><b><?php echo e($crime['count']); ?></b>/<?php echo e($section['data']['crime_type_distribution']->sum('count')); ?></span>
                                                        <div class="progress progress-sm">
                                                            <div class="progress-bar bg-primary" style="width: <?php echo e($section['data']['crime_type_distribution']->sum('count') > 0 ? ($crime['count'] / $section['data']['crime_type_distribution']->sum('count')) * 100 : 0); ?>%"></div>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php endif; ?>

                                        <!-- Station Efficiency Ranking -->
                                        <?php if(isset($section['data']['station_efficiency_ranking'])): ?>
                                            <div class="col-md-4">
                                                <h5>Station Efficiency Ranking</h5>
                                                <?php $__currentLoopData = $section['data']['station_efficiency_ranking']->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $station): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="d-flex justify-content-between align-items-center border-bottom py-2">
                                                        <span class="badge badge-<?php echo e($index < 2 ? 'success' : ($index < 4 ? 'warning' : 'secondary')); ?> mr-2"><?php echo e($index + 1); ?></span>
                                                        <span class="flex-grow-1"><?php echo e($station->name); ?></span>
                                                        <span class="badge badge-primary"><?php echo e($station->efficiency_score); ?></span>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                    <?php elseif($sectionKey === 'operational_alerts'): ?>
                        <!-- Operational Alerts -->
                        <div class="col-12">
                            <div class="card card-warning">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-bell mr-1"></i>
                                        <?php echo e($section['title']); ?>

                                    </h3>
                                </div>
                                <div class="card-body">
                                    <?php if(empty($section['data'])): ?>
                                        <div class="alert alert-success">
                                            <i class="fas fa-check-circle"></i> No operational alerts at this time.
                                        </div>
                                    <?php else: ?>
                                        <div class="row">
                                            <?php $__currentLoopData = $section['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-md-4">
                                                    <div class="alert alert-<?php echo e($alert['type']); ?>">
                                                        <h6><i class="fas fa-<?php echo e($alert['icon']); ?>"></i> <?php echo e($alert['title']); ?></h6>
                                                        <p class="mb-1"><?php echo e($alert['message']); ?></p>
                                                        <?php if(isset($alert['count'])): ?>
                                                            <span class="badge badge-<?php echo e($alert['type']); ?>"><?php echo e($alert['count']); ?> affected</span>
                                                        <?php endif; ?>
                                                        <?php if(isset($alert['action_url'])): ?>
                                                            <div class="mt-2">
                                                                <a href="<?php echo e($alert['action_url']); ?>" class="btn btn-<?php echo e($alert['type']); ?> btn-sm">Take Action</a>
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                    <?php elseif($sectionKey === 'station_overview'): ?>
                        <!-- Station Performance -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-chart-line mr-1"></i>
                                        <?php echo e($section['title']); ?>

                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-4 text-center">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-primary">
                                                    <i class="fas fa-plus"></i>
                                                </span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Cases This Month</span>
                                                    <span class="info-box-number"><?php echo e($section['data']['cases_this_month']); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-4 text-center">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-success">
                                                    <i class="fas fa-check"></i>
                                                </span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Solved This Month</span>
                                                    <span class="info-box-number"><?php echo e($section['data']['solved_this_month']); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-4 text-center">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-warning">
                                                    <i class="fas fa-percentage"></i>
                                                </span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Clearance Rate</span>
                                                    <span class="info-box-number"><?php echo e($section['data']['clearance_rate']); ?>%</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>

    <!-- Recent Activities -->
    <?php if(!empty($recentActivities)): ?>
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-clock mr-1"></i>
                            Recent Activities
                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="timeline">
                            <?php $__currentLoopData = $recentActivities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="time-label">
                                    <span class="bg-<?php echo e($activity['color']); ?>"><?php echo e($activity['time']); ?></span>
                                </div>
                                <div>
                                    <i class="<?php echo e($activity['icon']); ?> bg-<?php echo e($activity['color']); ?>"></i>
                                    <div class="timeline-item">
                                        <h3 class="timeline-header"><?php echo e($activity['title']); ?></h3>
                                        <div class="timeline-body">
                                            <?php echo e($activity['description']); ?>

                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Performance Metrics -->
            <?php if(!empty($performanceMetrics)): ?>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-chart-bar mr-1"></i>
                                Performance Metrics
                            </h3>
                        </div>
                        <div class="card-body">
                            <?php if(isset($performanceMetrics['case_closure_rate'])): ?>
                                <div class="info-box">
                                    <span class="info-box-icon bg-success">
                                        <i class="fas fa-check-circle"></i>
                                    </span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Your Case Closure Rate</span>
                                        <span class="info-box-number"><?php echo e($performanceMetrics['case_closure_rate']); ?>%</span>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if(isset($performanceMetrics['average_case_duration'])): ?>
                                <div class="info-box">
                                    <span class="info-box-icon bg-warning">
                                        <i class="fas fa-clock"></i>
                                    </span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Average Case Duration</span>
                                        <span class="info-box-number"><?php echo e($performanceMetrics['average_case_duration']); ?> days</span>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if(isset($performanceMetrics['station_efficiency'])): ?>
                                <div class="info-box">
                                    <span class="info-box-icon bg-info">
                                        <i class="fas fa-building"></i>
                                    </span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Station Efficiency</span>
                                        <span class="info-box-number"><?php echo e($performanceMetrics['station_efficiency']); ?>%</span>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="/css/admin_custom.css">
    <style>
        .timeline {
            position: relative;
            margin: 0 0 30px 0;
            padding: 0;
            list-style: none;
        }
        .timeline:before {
            content: '';
            position: absolute;
            top: 0;
            bottom: 0;
            width: 4px;
            background: #ddd;
            left: 31px;
            margin: 0;
            border-radius: 2px;
        }
        .timeline > div {
            margin-bottom: 15px;
            position: relative;
        }
        .timeline > div > .timeline-item {
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            border-radius: 3px;
            margin-top: 0;
            background: #fff;
            color: #444;
            margin-left: 60px;
            margin-right: 15px;
            padding: 0;
            position: relative;
        }
        .timeline > div > .fa,
        .timeline > div > .fas,
        .timeline > div > .far,
        .timeline > div > .fab,
        .timeline > div > .fal,
        .timeline > div > .fad,
        .timeline > div > .icon {
            width: 30px;
            height: 30px;
            font-size: 15px;
            line-height: 30px;
            position: absolute;
            color: #666;
            background: #d2d6de;
            border-radius: 50%;
            text-align: center;
            left: 18px;
            top: 0;
        }
        .timeline-header {
            margin: 0;
            color: #555;
            border-bottom: 1px solid #f4f4f4;
            padding: 10px;
            font-weight: 600;
            font-size: 16px;
        }
        .timeline-body {
            padding: 10px;
        }
        .time-label > span {
            font-weight: 600;
            color: #fff;
            font-size: 12px;
            padding: 5px;
            display: inline-block;
            border-radius: 4px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize Case Resolution Trend Chart
            <?php if(isset($sections['monthly_performance_trends']['data']['case_resolution_trend'])): ?>
                var ctx = document.getElementById('caseResolutionChart');
                if (ctx) {
                    var caseResolutionChart = new Chart(ctx, {
                        type: 'line',
                        data: {
                            labels: <?php echo json_encode($sections['monthly_performance_trends']['data']['case_resolution_trend']['months']); ?>,
                            datasets: [{
                                label: 'Total Cases',
                                data: <?php echo json_encode($sections['monthly_performance_trends']['data']['case_resolution_trend']['total_cases']); ?>,
                                borderColor: 'rgb(54, 162, 235)',
                                backgroundColor: 'rgba(54, 162, 235, 0.1)',
                                tension: 0.1
                            }, {
                                label: 'Resolved Cases',
                                data: <?php echo json_encode($sections['monthly_performance_trends']['data']['case_resolution_trend']['resolved_cases']); ?>,
                                borderColor: 'rgb(75, 192, 192)',
                                backgroundColor: 'rgba(75, 192, 192, 0.1)',
                                tension: 0.1
                            }]
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            scales: {
                                y: {
                                    beginAtZero: true
                                }
                            },
                            plugins: {
                                legend: {
                                    position: 'bottom'
                                }
                            }
                        }
                    });
                }
            <?php endif; ?>

            // Auto-refresh dashboard data every 5 minutes
            setInterval(function() {
                if (confirm('Refresh dashboard data?')) {
                    location.reload();
                }
            }, 300000); // 5 minutes

            // Enhanced tooltips for info boxes
            $('[data-toggle="tooltip"]').tooltip();

            // Animate progress bars
            $('.progress-bar').each(function() {
                var width = $(this).css('width');
                $(this).css('width', '0%').animate({
                    width: width
                }, 1000);
            });

            // Add click handlers for quick actions
            $('.quick-action-btn').on('click', function(e) {
                var action = $(this).data('action');
                if (action === 'critical') {
                    // Handle critical action with confirmation
                    if (!confirm('This will take you to critical cases. Continue?')) {
                        e.preventDefault();
                    }
                }
            });

            // Enhanced alert dismissal with fade effect
            $('.alert .close').on('click', function() {
                $(this).closest('.alert').fadeOut(300);
            });

            // Add loading states for action buttons
            $('.btn[href]').on('click', function() {
                var $btn = $(this);
                var originalText = $btn.html();
                $btn.html('<i class="fas fa-spinner fa-spin"></i> Loading...');
                
                setTimeout(function() {
                    $btn.html(originalText);
                }, 2000);
            });
        });

        // Function to format numbers with commas
        function numberWithCommas(x) {
            return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        }

        // Function to update dashboard stats dynamically
        function updateDashboardStats() {
            // This can be enhanced to fetch real-time data via AJAX
            console.log('Dashboard stats updated');
        }

        // Initialize dashboard enhancements
        $(function() {
            // Add hover effects to cards
            $('.card').hover(
                function() {
                    $(this).addClass('shadow-lg').css('transform', 'translateY(-2px)');
                },
                function() {
                    $(this).removeClass('shadow-lg').css('transform', 'translateY(0)');
                }
            );

            // Add click-to-expand functionality for large data sections
            $('.card-header').on('click', function() {
                var $card = $(this).closest('.card');
                var $body = $card.find('.card-body');
                
                if ($card.hasClass('collapsed')) {
                    $body.slideDown();
                    $card.removeClass('collapsed');
                } else if ($card.find('.collapse-toggle').length > 0) {
                    $body.slideUp();
                    $card.addClass('collapsed');
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/Desktop/police-ccms/resources/views/dashboard.blade.php ENDPATH**/ ?>